
	include	exec/exec_lib.i
	include	dos/dos_lib.i
	include	graphics/graphics_lib.i
	include	intuition/intuition_lib.i
	include	libraries/reqtools_lib.i
	include	resources/cia_lib.i
	include	hardware/cia.i
	include	newcustomreg


	move.l	sp,StackSave
	bsr	getmemory
	tst.l	d0
	beq.s	end
	bsr	init
	bsr	start
	rts
end:
	rts
init:
	bsr	task_find
	bsr	intlib_open
	bsr	gfxlib_open
	bsr	doslib_open
	bsr	screen_open
	bsr	window_open
;	bsr	con_open
	bsr.s	int_open
	bsr	SetInputHandler
	bsr	DoCopWotsit
	bsr	InitCIABInts
	rts

int_open:
	move.l	4.w,a6
	lea	COPPER_INT,a1
	moveq	#4,d0
	jsr	_LVOAddIntServer(a6)
	rts


int_close:
	move.l	4.w,a6
	lea	COPPER_INT,a1
	moveq	#4,d0
	jsr	_LVORemIntServer(a6)
	rts

DoCopWotsit:
	moveq	#12,d0
	move.l	#$10002,d1
	jsr	_LVOAllocMem(a6)
	move.l	d0,UCopAddy
	beq	qu
	move.l	ScreenHD,a0
	move.l	UCopAddy,64(a0)		; set pointer to usercopperlist
	move.l	GfxBase,a6

	moveq	#0,d0
	moveq	#0,d1
	move.l	UCopAddy,a1
	jsr	_LVOCWait(a6)
	move.l	UCopAddy,a1
	jsr	_LVOCBump(a6)

	move.l	UCopAddy,a1
	move.l	#$86,d0
	move.l	#MyCopList,d1
	and.l	#$ffff,d1
	jsr	_LVOCMove(a6)
	move.l	UCopAddy,a1
	jsr	_LVOCBump(a6)
	move.l	#$84,d0
	move.l	#MyCopList,d1
	swap	d1
	and.l	#$ffff,d1
	move.l	UCopAddy,a1
	jsr	_LVOCMove(a6)
	move.l	UCopAddy,a1
	jsr	_LVOCBump(a6)
	move.l	#$8a,d0
	moveq	#0,d1
	move.l	UCopAddy,a1
	jsr	_LVOCMove(a6)
	move.l	UCopAddy,a1
	jsr	_LVOCBump(a6)
	move.l	#10000,d0
	move.l	#255,d1
	move.l	UCopAddy,a1
	jsr	_LVOCWait(a6)

	move.l	IntBase,a6
	jsr	_LVORemakeDisplay(a6)
	rts

UndoCopWotsit:
	move.l	UCopAddy,a0
	tst.l	a0
	beq.s	.ov1

	move.l	ScreenHD,a1
	lea	44(a1),a0
	move.l	GfxBase,a6
	jsr	_LVOFreeVPortCopLists(a6)
.ov1
	move.l	IntBase,a6
	move.l	ScreenHD,a0
	jsr	_LVORemakeDisplay(a6)
	rts	

con_open:
	move.l	#consolname,d1
	move.l	#1005,d2
	move.l	dosbase,a6
	jsr	_LVOOpen(a6)
	move.l	d0,conhandle
	rts

con_close:
	move.l	conhandle,d1
	move.l	dosbase,a6
	jsr	_LVOClose(a6)
	rts

******************************************************************************
;TIMER Stuff.
******************************************************************************

InitCIABInts:
	move.l	4.w,a6
	lea	CIAbName,a1
	jsr	_LVOOpenResource(a6)	; get pointer to resource
	move.l	d0,CIAbBase
	beq.w	qu

	move.l	d0,a6
	moveq	#0,d0			; now to actually install interrupt
	lea	TIMERA_IS,a1
	jsr	_LVOAddICRVector(a6)
	tst.l	d0
	bne.w	qu			; Leave if not available

	moveq	#1,d0			; now to actually install interrupt
	lea	TIMERB_IS,a1
	jsr	_LVOAddICRVector(a6)
	tst.l	d0
	bne.w	qu			; Leave if not available


;	move.b	#$7f,$BFDD00
	move.l	#1,IntsSet		; Check so KillCIA can tell whether
					;  to disable again...
	rts

KillCIABInts:
	movem.l	d0-a6,-(sp)
	tst.l	IntsSet			; Kill int?
	beq.s	.end			; nope

	move.l	CIAbBase,a6
	moveq	#0,d0
	lea	TIMERA_IS,a1
	jsr	_LVORemICRVector(a6)	; Pow
;	lea	$bfdd00,a0
;	move.b	#$7f,(a0)

	move.l	CIAbBase,a6
	moveq	#1,d0
	lea	TIMERB_IS,a1
	jsr	_LVORemICRVector(a6)	; Pow

.end	movem.l	(sp)+,d0-a6
	rts

qu:
	tst.w	ResetCPU
	bne	DoReset
	move.l	StackSave,sp

	bsr.s	KillCIABInts
	bsr	UndoCopWotsit
	bsr	ResetInputHandler
	bsr	freememory
;	bsr.s	con_close
	bsr	window_close
	bsr	screen_close
	bsr	int_close
	bsr	gfxlib_close
	bsr	intulib_close
	bra	doslib_close
	
DoReset:
	move.w	#0,ResetCPU
	bset	#16,d3
	st.b	IDF
	move.w	#0,CISData
	move.w	#$fce2,d6
	move.l	d6,a4
	bra	start2

getmemory:
	move.l	#40000,d0
	move.l	#$10002,d1
	move.l	4.w,a6
	jsr	_LVOAllocMem(a6)
	move.l	d0,BPL1Address
	beq	fail
	add.l	#8000,d0
	move.l	d0,BPL2Address
	add.l	#8000,d0
	move.l	d0,BPL3Address
	add.l	#8000,d0
	move.l	d0,BPL4Address
	add.l	#8000,d0
	move.l	d0,BPL5Address

	move.l	BPL1Address,d0
	move.w	d0,Screen+6
	swap	d0
	move.w	d0,Screen+2

	move.l	BPL2Address,d0
	move.w	d0,Screen+6+8
	swap	d0
	move.w	d0,Screen+2+8

	move.l	BPL3Address,d0
	move.w	d0,Screen+6+16
	swap	d0
	move.w	d0,Screen+2+16

	move.l	BPL4Address,d0
	move.w	d0,Screen+6+24
	swap	d0
	move.w	d0,Screen+2+24

	move.l	BPL5Address,d0
	move.w	d0,Screen+6+32
	swap	d0
	move.w	d0,Screen+2+32

	move.l	#RasterL,d0
	move.w	d0,RastLP+2
	swap	d0
	move.w	d0,RastLP+6

	move.l	#524288,d0
	move.l	#$10001,d1
	move.l	4.w,a6
	jsr	_LVOAllocMem(a6)
	move.l	d0,BitPlaneTable
	beq	fail1
	add.l	#262144,d0
	move.l	d0,MultiTable

	move.l	#6144,d0
	move.l	#$10001,d1
	move.l	4.w,a6
	jsr	_LVOAllocMem(a6)
	move.l	d0,Directory
	beq	fail2

GetFAST:	
	move.l	#851968,d0
	move.l	#$10001,d1
	move.l	4.w,a6
	jsr	_LVOAllocMem(a6)	
	move.l	d0,Address
	beq	fail3
	move.l	#851968,d0
	move.l	4.w,a6
	move.l	Address,a1
	jsr	_LVOFreeMem(a6)
	move.l	Address,d0
	add.l	#$10000,d0
	move.w	#0,d0
	move.l	d0,a1
	move.l	#786432,d0
	move.l	4.w,a6
	jsr	_LVOAllocAbs(a6)
	move.l	d0,Address
	beq.s	GetFAST
	add.l	#$15000,d0
	move.l	d0,BasicRAM
	add.l	#$2000,d0
	move.l	d0,KernalRAM
	add.l	#$2000,d0
	move.l	d0,CharRAM
	add.l	#$1000,d0
	move.l	d0,ShadowCopy
	add.l	#$2000,d0
	move.l	d0,IORAM
	add.l	#$24000,d0
	move.l	d0,WriteTable
	add.l	#$20000,d0
	move.l	d0,ReadTable
	rts

freememory:
	move.l	Address,a1
	move.l	#786432,d0
	move.l	4.w,a6
	jsr	_LVOFreeMem(a6)
fail3:
	move.l	Directory,a1
	move.l	#6144,d0
	move.l	4.w,a6
	jsr	_LVOFreeMem(a6)
fail2:
	move.l	BitPlaneTable,a1
	move.l	#524288,d0
	jsr	_LVOFreeMem(a6)
fail1:
	move.l	BPL1Address,a1
	move.l	#40000,d0
	jsr	_LVOFreeMem(a6)
fail:
	moveq	#0,d0
	rts

task_find:
	sub.l	a1,a1
	move.l	4.w,a6
	jsr	_LVOFindTask(a6)
	move.l	d0,taskpt
	rts

intlib_open:
	move.l	4.w,a6
	moveq	#0,d0
	lea	intuname(pc),a1
	jsr	_LVOOpenLibrary(a6)
	move.l	d0,IntBase
	moveq	#0,d0
	lea	RTname(pc),a1
	jsr	_LVOOpenLibrary(a6)
	move.l	d0,RTBase
	rts

intulib_close:
	move.l	4.w,a6
	moveq	#0,d0
	move.l	IntBase(pc),a1
	jsr	_LVOCloseLibrary(a6)
	bsr	endreq
	rts

doslib_open:
	move.l	4.w,a6
	moveq	#0,d0
	lea	dosname(pc),a1
	jsr	_LVOOpenLibrary(a6)
	move.l	d0,dosbase
	rts

doslib_close:
	move.l	4.w,a6
	moveq	#0,d0
	move.l	dosbase(pc),a1
	jsr	_LVOCloseLibrary(a6)
	rts

gfxlib_open:
	move.l	4.w,a6
	moveq	#0,d0
	lea	GfxName(pc),a1
	jsr	_LVOOpenLibrary(a6)
	move.l	d0,GfxBase
	rts

gfxlib_close:
	move.l	4.w,a6
	moveq	#0,d0
	move.l	GfxBase(pc),a1
	jsr	_LVOCloseLibrary(a6)
	rts

screen_open:
	lea.l	screen_defs(pc),a0
	moveq	#0,d0
	move.l	IntBase(pc),a6
	jsr	_LVOOpenScreen(a6)
	move.l	d0,ScreenHD
	rts

screen_close:
	move.l	ScreenHD(pc),a0
	move.l	IntBase(pc),a6
	jsr	_LVOCloseScreen(a6)
	rts

window_open:
	move.l	IntBase(pc),a6
	lea	window_defs(pc),a0
	jsr	_LVOOpenWindow(a6)
	move.l	d0,windowhd
	move.l	taskpt(pc),a0
	move.l	$b8(a0),taskoldwin
	move.l	d0,$b8(a0)
	rts

window_close:
	move.l	taskpt(pc),a0
	move.l	taskoldwin(pc),$b8(a0)
	move.l	IntBase(pc),a6
	move.l	windowhd(pc),a0
	jsr	_LVOCloseWindow(a6)
	rts

SetInputHandler:
	moveq	#-1,d0
	move.l	4.w,a6
	jsr	_LVOAllocSignal(a6)
	move.l	d0,d2
	move.l	d0,MySig
	sub.l	a1,a1
	jsr	_LVOFindTask(a6)
	move.l	d0,MyTask
	lea	InputEP(pc),a1		;input event port
	move.b	#0,9(a1)		;List Node Priority
	move.l	#0,10(a1)		;List Node Name
	move.b	#4,8(a1)		;NT_MsgPort -> Node Type
	move.b	d2,15(a1)		;MP_SigBit
	move.l	d0,16(a1)		;MP_SigTask
	jsr	_LVOAddPort(a6)
	lea	idevname(pc),a0
	lea	IEIOReq(pc),a1
	moveq	#0,d0
	moveq	#0,d1
	move.l	#InputEP,14(a1)
	jsr	_LVOOpenDevice(a6)
	lea	IEIOReq(pc),a1
	move.w	#9,28(a1)		;IO_Command
	move.b	#1,30(a1)		;IO_Flags
	move.l	#InputEF,40(a1)		;IO_Flags
	jsr	_LVODoIO(a6)
	rts

ResetInputHandler:
	move.l	4.w,a6
	lea	IEIOReq(pc),a1
	move.w	#10,28(a1)		;IO_Command
	move.b	#1,30(a1)		;IO_Flags
	move.l	#InputEF,40(a1)		;IO_Data
	jsr	_LVODoIO(a6)
	lea	IEIOReq(pc),a1
	jsr	_LVOCloseDevice(a6)
	lea	InputEP(pc),a1
	jsr	_LVORemPort(a6)
	move.l	MySig,d0
	jsr	_LVOFreeSignal(a6)
	rts

;InputHandler:
;	move.l	a0,d0
;	cmp.b	#1,4(a0)
;	bne.s	.over
;	movem.l	d0/a6,-(sp)
;	moveq	#0,d0
;	move.w	6(a0),d0
;	cmp.w	#$65,d0
;	bls.s	.ov
;
;	move.w	#-1,KeyCode
;	bra.s	.ov1
;
;.ov	cmp.w	#$45,d0
;	beq.s	.esc
;	move.w	d0,KeyCode
;;	move.w	#1,KeyCode
;	move.w	8(a0),KeyQual
;
;	moveq	#0,d0
;.ov1	movem.l	(sp)+,d0/a6
;.over	rts
;.esc	move.w	#-1,ISData
;	moveq	#0,d0
;	movem.l	(sp)+,d0/a6
;	rts
	
InputHandler:
	move.l	a0,d0
	cmp.b	#1,4(a0)
	bne.s	.over

	move.l	a1,-(sp)
	lea	KeyBuffer(pc),a1
	move.w	6(a0),d0
	cmp.w	#$80,d0
	bhs.s	.doqual
	
	move.b	d0,(a1)+
	cmp.w	#$45,d0
	beq.s	.esc
	cmp.w	#$5d,d0
	beq.s	.kpstar

.doqual	move.w	8(a0),d0
	and.b	#$1f,d0
	beq.s	.noqual
	lsr.b	d0
	bcc.s	.nolsh
	move.b	#$60,(a1)+

.nolsh	lsr.b	d0
	bcc.s	.norsh
	move.b	#$61,(a1)+

.norsh	lsr.b	d0
	bcc.s	.nocaps
	move.b	#$62,(a1)+

.nocaps	lsr.b	d0
	bcc.s	.noctrl
	move.b	#$63,(a1)+

.noctrl	lsr.b	d0
	bcc.s	.noqual
	move.b	#$64,(a1)+
	
.noqual	move.b	#-1,(a1)+	; mark end of buffer
;	moveq	#0,d0
	move.l	(sp)+,a1
.over	move.l	a0,d0
	rts

.nokey	
	move.b	#-1,KeyBuffer	
	move.l	a0,d0
	rts

.esc
	move.l	(sp)+,a1
	move.w	#-1,CISData
	move.l	a0,d0
	rts
.kpstar
	move.l	(sp)+,a1
	move.w	#1,ResetCPU
	move.w	#-1,CISData
	move.l	a0,d0
	rts

openfile:
	move.l	#1005,d2
	move.l	dosbase,a6
	jsr	_LVOOpen(a6)
	move.l	d0,filehd
	rts

closefile:
	move.l	dosbase,a6
	move.l	filehd,d1
	jsr	_LVOClose(a6)
	rts

readdata:
	move.l	dosbase,a6
	move.l	filehd,d1
	jsr	_LVORead(a6)
	rts

pmsg:
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	conhandle,d1
	move.l	dosbase,a6
	jsr	_LVOWrite(a6)		;write uses d1-file,d2-location,d3-len
	movem.l	(sp)+,d0-d7/a0-a6
	rts

hexin:
	tst.b	(a0)
	beq.s	hexinok
	cmp.b	#32,(a0)
	beq.s	hexinok
	moveq	#0,d0
	move.b	(a0)+,d0
	cmp.b	#$60,d0
	ble.s	upper
	sub.b	#$20,d0
upper:
	sub.b	#'A',d0
	bcc.s	ischar
	addq.b	#7,d0
ischar:
	add.b	#10,d0
	lsl.l	#4,d1
	or.b	d0,d1
	bra.s	hexin
hexinok:
	rts

loadROMs:
	move.w	#0,a5
	move.l	RTBase,a6
	move.l	freq,a1
	moveq	#0,d0
	sub.l	a0,a0
	jsr	_LVOrtAllocRequestA(a6)
	tst.l	d0
	beq	errorreq
	move.l	d0,freq
	move.l	d0,a1
	lea	myreqtag,a0
	jsr	_LVOrtChangeReqAttrA(a6)	;changes dir
	lea	Buffer2(pc),a2		;Filename
	moveq	#0,d0
	lea	RTitle(pc),a3		;Title of requester
	move.l	freq,a1
	lea	freqtags,a0
	jsr	_LVOrtFileRequestA(a6)
	tst.l	d0
	beq	cancel
	move.l	freq,a2
	move.l	16(a2),a2		;directory
	move.l	#Buffer2,a0		;filename
	move.l	#inbuff,a1		;destination
	moveq	#0,d0
.loop
	move.b	(a2,d0),(a1,d0)
	addq.b	#1,d0
	cmp.b	#0,(a2,d0)
	beq.s	.done
	bra.s	.loop
.done
	cmp.b	#':',-1(a2,d0)
	beq.s	.over4
	move.b	#'/',(a1,d0)
	addq.b	#1,d0
.over4
	moveq	#0,d1
.loop3
	move.b	(a0,d1),(a1,d0)
	cmp.b	#0,(a1,d0)
	beq.s	readfile
	addq.b	#1,d1
	addq.b	#1,d0
	bra.s	.loop3

endreq:
	move.l	freq,a1
	move.l	RTBase,a6
	cmp.l	#0,a6
	beq.s	.end
	jsr	_LVOrtFreeRequest(a6)
	move.l	4.w,a6
	move.l	RTBase,a1
	jsr	_LVOCloseLibrary(a6)
.end
	rts

errorreq:
	rts

cancel:
	rts

readfile:
	move.l	d0,bufflen
	
	move.l	#kernal,d1
	bsr	openfile
	move.l	#$2000,d3
	move.l	Address,d2
	add.l	#$e000,d2
	bsr	readdata
	bsr	closefile
	move.l	Address,a1
	move.l	a1,a2		;copy roms
	add.l	#$12000,a2
	add.l	#$e000,a1
	moveq	#0,d0
.loop1	move.l	(a1,d0.l),(a2,d0.l)
	addq.l	#4,d0
	cmp.l	#$2000,d0
	bcs.s	.loop1

	move.l	#basic,d1
	bsr.w	openfile
	move.l	#$2000,d3
	move.l	Address,d2
	add.l	#$a000,d2
	bsr	readdata
	bsr.w	closefile
	move.l	Address,a1
	move.l	a1,a2		;copy roms
	add.l	#$10000,a2
	add.l	#$a000,a1
	moveq	#0,d0
.loop2	move.l	(a1,d0.l),(a2,d0.l)
	addq.l	#4,d0

	cmp.l	#$2000,d0
	bcs.s	.loop2

	move.l	#char,d1
	bsr.w	openfile
	move.l	#$1000,d3
	move.l	Address,d2
	add.l	#$14000,d2
	move.l	d2,CROMAddy
	bsr.w	readdata
	bsr.w	closefile

	rts

TimerA_Int:
	tst.b	IDF
	bne.s	.over
	move.w	#1,CISData
	moveq	#0,d0
	rts
.over
	or.b	#1,IntSR
	moveq	#0,d0
	rts

TimerB_Int:
	tst.b	IDF
	bne.s	.over
	move.w	#1,CISData
	moveq	#0,d0
	rts
.over
	or.b	#2,IntSR
	moveq	#0,d0
	rts

CISInterrupt:
	movem.l	a0/d5,-(sp)
	move.l	Address,a0
	lea	($d019.l,a0),a0
	tst.b	IDF
	bne.s	.over
	move.b	(a0),d5
	and.b	#%00001110,d5
	or.b	#%01110001,d5
	move.b	d5,(a0)
	btst	#0,1(a0)
	beq.s	.over1
	bset	#7,(a0)
	move.w	#1,CISData
.over1
	move.b	(a0),IntFRTemp
	movem.l	(sp)+,a0/d5
	moveq	#0,d0
	rts
.over
	move.b	(a0),IntFRTemp
	or.b	#4,IntSR
	movem.l	(sp)+,a0/d5
	moveq	#0,d0
	rts

SetUpScreen:
	move.l	BPL1Address,a0
	move.l	#1999,d0
.loop
	move.l	#-1,(a0)+
	dbra	d0,.loop

	rts

SetUpColourLookup:
	lea	ColLUT,a0
	moveq	#24,d0
	moveq	#18,d1
.loop
	moveq	#39,d2
.loop1
	move.w	d1,(a0)+
	addq.w	#4,d1
	dbra	d2,.loop1
	add.l	#20,d1
	dbra	d0,.loop

	lea	BMLUT,a0
	moveq	#0,d0
	moveq	#24,d3
.loop4
	moveq	#39,d2
.loop3
	moveq	#7,d1
.loop2
	move.w	d0,(a0)+
	add.l	#40,d0
	dbra	d1,.loop2
	sub.l	#319,d0
	dbra	d2,.loop3
	add.l	#280,d0
	dbra	d3,.loop4
	rts

SetUpScreenLookup:
	lea	ScrLUT,a0
	move.l	#999,d2
	moveq	#0,d0
.lp
	move.l	d0,d6		; character offset from top left
	move.l	d6,d4
	divu	#40,d6
	and.l	#$ffff,d6
	mulu	#40,d6
	sub.l	d6,d4
	lsl.l	#3,d6
	add.l	d4,d6
	move.w	d6,(a0)+
	addq.l	#1,d0
	dbra	d2,.lp
	rts

BuildTables1:
	lea	MonoMode,a0
	lea	Stretch,a1
	lea	TextTable,a2
	moveq	#0,d6			;data counter
.main
	moveq	#0,d7			;colour counter
.loop
	move.l	(a1,d6.l*4),d0
	move.l	(a0,d7.l*4),d2
	and.l	d0,d2
	move.b	d6,d1
	eor.b	#255,d1
	or.b	d1,d2
	move.l	d2,(a2)+
	addq.b	#1,d7
	cmp.b	#16,d7
	bne.s	.loop
	addq.b	#1,d6
	bne.s	.main

	lea	MonoMode,a0
	lea	Stretch,a1
	move.l	BitPlaneTable,a2
	moveq	#0,d0			;data
	move.l	#255,d6			;data counter
.main1
	move.l	#255,d7			;colour counter
.loop1
	move.l	d6,d0
	eor.b	#255,d0
	move.l	d6,d1
	move.l	d7,d2
	eor.b	#255,d2
	move.l	d2,d3
	and.b	#15,d3
	lsr.b	#4,d2
	move.l	(a1,d0.l*4),d0
	move.l	(a1,d1.l*4),d1
	move.l	(a0,d2.l*4),d4
	move.l	(a0,d3.l*4),d5
	and.l	d0,d4
	and.l	d1,d5
	or.l	d4,d5
	move.l	d5,(a2)+
	dbra	d7,.loop1
	dbra	d6,.main1

	lea	MonoMode,a0
	move.l	MultiTable,a1
	moveq	#0,d7			;64 data
.main2
	moveq	#0,d1
.mloop
	move.l	d1,d6			;64 Screen data (1024) %01=u %10=l
	move.l	d6,d5
	and.w	#15,d5
	lsr.b	#4,d6

	moveq	#3,d3
	moveq	#30,d0
	moveq	#0,d2			;amiga long dest
.loop2
	bfextu	d7{d0:2},d4
	beq	.screen
	cmp.b	#2,d4
	beq.s	.lower
	cmp.b	#3,d4
	beq	.colour
.upper
	move.b	3(a0,d6.l*4),d4
	and.b	#3,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	move.b	2(a0,d6.l*4),d4
	and.b	#3,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	move.b	1(a0,d6.l*4),d4
	and.b	#3,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	move.b	(a0,d6.l*4),d4
	and.b	#3,d4
	bfins	d4,d2{d0:2}
	add.b	#22,d0
	dbra	d3,.loop2
	move.l	d2,(a1)+
	addq.b	#1,d1
	bne.s	.mloop
	addq.b	#1,d7
	bne.s	.main2
	rts
.lower
	move.b	3(a0,d5.l*4),d4
	and.b	#3,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	move.b	2(a0,d5.l*4),d4
	and.b	#3,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	move.b	1(a0,d5.l*4),d4
	and.b	#3,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	move.b	(a0,d5.l*4),d4
	and.b	#3,d4
	bfins	d4,d2{d0:2}
	add.b	#22,d0
	dbra	d3,.loop2
	move.l	d2,(a1)+
	addq.b	#1,d1
	bne	.mloop
	addq.b	#1,d7
	bne	.main2
	rts
.screen
	moveq	#3,d4
	bfins	d4,d2{d0:2}		;plane1
	subq.b	#8,d0
	moveq	#0,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	bfins	d4,d2{d0:2}
	add.b	#22,d0
	dbra	d3,.loop2
	move.l	d2,(a1)+
	addq.b	#1,d1
	bne	.mloop
	addq.b	#1,d7
	bne	.main2
	rts
.colour
	bfins	d4,d2{d0:2}		;plane1
	subq.b	#8,d0
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	bfins	d4,d2{d0:2}
	add.b	#22,d0
	dbra	d3,.loop2
	move.l	d2,(a1)+
	addq.b	#1,d1
	bne	.mloop
	addq.b	#1,d7
	bne	.main2
	rts

BuildTables2:
	lea	MCMBackground,a0
	moveq	#0,d1
	moveq	#0,d5
.start	
	moveq	#0,d2
	moveq	#3,d3
	moveq	#30,d7
.loop1
	moveq	#3,d4
	bfextu	d5{d7:2},d1
	bne.s	.over
	moveq	#0,d4
.over
	bfins	d4,d2{d7:2}
	subq.b	#2,d7
	dbra	d3,.loop1
	move.b	d2,(a0)+
	addq.b	#1,d5
	bne.s	.start

	lea	MonoMode,a0
	lea	MCMColour,a1

	moveq	#0,d1
	moveq	#0,d5
.begin
	moveq	#0,d0
.main
	moveq	#0,d2
	moveq	#3,d3
	moveq	#30,d7
.loop
	bfextu	d5{d7:2},d1
	cmp.b	#3,d1
	beq.s	.colour
	moveq	#3,d4
	bfins	d4,d2{d7:2}
	subq.b	#8,d7
	bfins	d4,d2{d7:2}
	subq.b	#8,d7
	bfins	d4,d2{d7:2}
	subq.b	#8,d7
	bfins	d4,d2{d7:2}
	add.b	#22,d7
	dbra	d3,.loop
	move.l	d2,(a1)+
	addq.b	#1,d0
	cmp.b	#16,d0
	bne.s	.main
	addq.b	#1,d5
	bne.s	.begin
	rts

.colour
	move.b	3(a0,d0.l*4),d4
	and.b	d1,d4
	bfins	d4,d2{d7:2}
	subq.b	#8,d7
	move.b	2(a0,d0.l*4),d4
	and.b	d1,d4
	bfins	d4,d2{d7:2}
	subq.b	#8,d7
	move.b	1(a0,d0.l*4),d4
	and.b	d1,d4
	bfins	d4,d2{d7:2}
	subq.b	#8,d7
	move.b	0(a0,d0.l*4),d4
	and.b	d1,d4
	bfins	d4,d2{d7:2}
	add.b	#22,d7
	dbra	d3,.loop
	move.l	d2,(a1)+
	addq.b	#1,d0
	cmp.b	#16,d0
	bne.s	.main
	addq.b	#1,d5
	bne	.begin
	rts

BuildTables3:
	lea	MultiTextBack,a0
	moveq	#0,d1
	moveq	#0,d5
.start1
	moveq	#0,d2
	moveq	#3,d3
	moveq	#30,d7
.loop1
	moveq	#0,d4
	bfextu	d5{d7:2},d1
	cmp.b	#3,d1
	bne.s	.over
	moveq	#3,d4
.over
	bfins	d4,d2{d7:2}
	subq.b	#2,d7
	dbra	d3,.loop1
	move.b	d2,(a0)+
	addq.b	#1,d5
	bne.s	.start1

	lea	MonoMode,a0
	lea	MultiTextTable,a1
	moveq	#0,d7			;64 data
.begin
	moveq	#0,d1
.main
	moveq	#3,d3
	moveq	#30,d0
	moveq	#0,d2			;amiga long dest
.loop
	bfextu	d7{d0:2},d4
	beq	.screen
	cmp.b	#2,d4
	beq.s	.lower
	cmp.b	#3,d4
	beq	.colour
.upper				;color03
	moveq	#3,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	bfins	d4,d2{d0:2}
	moveq	#0,d4
	subq.b	#8,d0
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	bfins	d4,d2{d0:2}
	add.b	#22,d0
	dbra	d3,.loop
	move.l	d2,(a1)+
	addq.b	#1,d1
	cmp.b	#16,d1
	bne.s	.main
	addq.b	#1,d7
	bne.s	.begin	
	rts

.lower				;color05
	moveq	#3,d4
	bfins	d4,d2{d0:2}
	sub.b	#16,d0
	bfins	d4,d2{d0:2}
	addq.b	#8,d0
	moveq	#0,d4
	bfins	d4,d2{d0:2}
	sub.b	#16,d0
	bfins	d4,d2{d0:2}
	add.b	#22,d0
	dbra	d3,.loop
	move.l	d2,(a1)+
	addq.b	#1,d1
	cmp.b	#16,d1
	bne.s	.main
	addq.b	#1,d7
	bne	.begin	
	rts

.screen
	moveq	#3,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	moveq	#0,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	bfins	d4,d2{d0:2}
	add.b	#22,d0
	dbra	d3,.loop
	move.l	d2,(a1)+
	addq.b	#1,d1
	cmp.b	#16,d1
	bne	.main
	addq.b	#1,d7
	bne	.begin	
	rts
.colour
	move.b	3(a0,d1.l*4),d4
	and.b	#3,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	move.b	2(a0,d1.l*4),d4
	and.b	#3,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	move.b	1(a0,d1.l*4),d4
	and.b	#3,d4
	bfins	d4,d2{d0:2}
	subq.b	#8,d0
	move.b	(a0,d1.l*4),d4
	and.b	#3,d4
	bfins	d4,d2{d0:2}
	add.b	#22,d0
	dbra	d3,.loop
	move.l	d2,(a1)+
	addq.b	#1,d1
	cmp.b	#16,d1
	bne	.main
	addq.b	#1,d7
	bne	.begin	
	rts

; Mainloop register summary:
; Indented regs can be modified under controlled circumstances

;	a0 -MAR - Points to last 64 memory Address used.
;	a1 -Write/Read base. Set at end of a 64 ins. Can fiddle with.
;	a2 -Write Base. Dont fiddle. Hands off! Capisce?
;	a3 -64 Stack pointer. Leave top 16 bits ALONE!
;	a4 -64 Program counter. Leave top 16 bits alone.
;	a5 -Pointer to Address of last 020 routine of last c64 instruction.
;	a6 -Pointer to shadow RAM. Leave top 16 bits ALONE!
;	d0 -Accumulator. Top 24 bits must be zero.
;	d1 -X registor. Top 24 bits must be 0
;	d2 -Y register. Same as above.
;	d3 -C64 Status register.
;	d4 - 	Temp.		Read instructions must leave bits >15 = 0
;	d5 - 	Temp.
;	d6 - 	Temp.
;	d7 -	Temp.		Read instructions must leave bits 9-15 = 0

;	MODE		suffix		bytes
;	(Absolute,x)	x1		3
;	(Absolute,y)	y1		3
;	(z-page,x)	x1z		2
;	(z-page,y)	y1z		2
;	(Ind,x)		x		2
;	((Ind),y)	y		2
;	immidate	h		2
;	zeropage	z		2


FlagNZ	Macro
	move	ccr,d5
	and.w	#3,d3
	and.w	#12,d5
	or.b	d5,d3
	ENDM

FlagCNZ	Macro
	move	ccr,d5
	and.w	#2,d3
	and.w	#13,d5
	or.b	d5,d3
	ENDM

FlagCMP	Macro
	move	ccr,d5
	and.w	#2,d3
	and.w	#13,d5
	eor.b	#1,d5
	or.b	d5,d3
	ENDM

FlagSUB	Macro
	eor.b	#1,d3
	lsr.b	#1,d3
	moveq	#0,d5
	subx.b	d6,d0
	move	ccr,d3
	eor.b	#1,d3
	ENDM

FlagADD	Macro
	lsr.b	#1,d3
	moveq	#0,d5
	addx.b	d6,d0
	move	ccr,d3
	ENDM

FlagROL	Macro
	move.w	d3,d5
	lsr.b	#1,d5
	roxl.b	\1
	move	ccr,d5
	and.w	#13,d5
	and.w	#2,d3
	or.b	d5,d3
	ENDM

FlagROR	Macro
	move.w	d3,d5
	lsr.b	#1,d5
	roxr.b	\1
	move	ccr,d5
	and.w	#13,d5
	and.w	#2,d3
	or.b	d5,d3
	ENDM

FlagLSR	Macro
	move	ccr,d5
	and.w	#2,d3
	and.w	#5,d5
	or.b	d5,d3
	ENDM

InsAX	Macro
	move.w	d1,d6
	add.b	(a4)+,d6
	addq.b	#1,d6
	move.l	d6,a0
	move.b	(a0),d5
	lsl.w	#8,d5
	subq.b	#1,d6
	move.l	d6,a0
	move.b	(a0),d5	
	move.w	d5,d6
	move.l	d6,a0
	ENDM

InsAY	Macro
	sub.w	d6,d6
	move.b	(a4)+,d6
	addq.b	#1,d6
	move.l	d6,a0
	move.b	(a0),d5
	lsl.w	#8,d5
	subq.b	#1,d6
	move.l	d6,a0
	move.b	(a0),d5
	add.w	d2,d5
	move.w	d5,d6
	move.l	d6,a0
	ENDM

RWChk	Macro
	move.w	a0,d4
	move.w	(a6,d4.l*2),d7
	jsr	([a2,d7.l*4])
	jmp	start2
	ENDM

RWChk2	Macro
	move.w	a0,d4
	move.w	(a6,d4.l*2),d7
	jsr	([$20000,a2,d7.l*4])
	ENDM

ZeroP	Macro
	move.w	a0,d4
	cmp.w	#1,d4
	bne	start2
	jmp	IOPort
	ENDM
	
PackA	Macro
	move.w	d3,d5
	move.w	d3,d7
	lsr.w	#8,d5
	lsr.w	#4,d5
	and.w	#$F0,d5
	and.w	#15,d7
	or.b	d5,d7
	ENDM
	
UnPackA	Macro
	move.w	d3,d5
	and.w	#$f0,d5
	lsl.w	#8,d5
	lsl.w	#4,d5
	and.w	#15,d3
	or.w	d5,d3
	ENDM

start:
	bsr	BuildTables1
	bsr	BuildTables2
	bsr	BuildTables3
	bsr	SetUpScreenLookup
	bsr	SetUpColourLookup
	bsr	SetUpScreen
	bsr	loadROMs
	move.l	Address,a6
	add.l	#$20000,a6
	move.l	WriteTable,a2
	move.l	ReadTable,a1
	bsr	InitSRAM
	move.l	ScreenHD,a0
	lea	44(a0),a0
	moveq	#40,d0
	lea	colour64(pc),a1
	move.l	GfxBase,a6
	jsr	_LVOLoadRGB4(a6)
	move.l	Address,a4		;Address of Alloc'ed mem
	move.l	a4,a6
	move.l	a4,CharAddress
	move.l	a4,ScreenAddress
	add.l	#1024,ScreenAddress
	add.l	#$20000,a6		;a6 = ^ SRAM
	moveq	#0,d0			;d0=ac,d1=xr,d2=yr,d3=sr,a4=64pc
	moveq	#0,d1
	moveq	#0,d2
	move.l	#$10000,d3
	move.l	#$fce2,d4
	move.w	#$01ff,a3
	add.l	a4,a3
	move.l	a4,d6
	move.l	a4,a0			;a3=64SP,a0=64MAR
	move.l	#$d018,d5
	move.b	#21,(a4,d5.l)
	move.l	WriteTable,a2		; a2 is WriteBase
	add.l	d4,a4
	moveq	#0,d4
	move.l	a7,StackSave
	lea	table,a7
	moveq	#0,d7
	bra	start2

	cnop	0,4
				; reminder!!! d7 - Make sure all read ins
				; leave bits 8 to 15 = 0!!! NBNBNBNBNB

start2:
	tst.w	CISData
	bne.s	DoIRQ
	move.b	(a4)+,d7
	jmp	([a7,d7.w*4])

	cnop	0,4

DoIRQ:
	cmp.w	#-1,CISData
	beq	qu
	bset	#16,d3
	st.b	IDF
	move.w	#0,CISData
	move.w	a3,d6
	subq.b	#1,d6
	move.l	d6,a0
	move.w	a4,d5
	move.b	d5,(a0)
	addq.b	#1,d6
	move.l	d6,a0
	lsr.w	#8,d5
	move.b	d5,(a0)
	subq.b	#2,d6
	move.l	d6,a0
	lea	ACTable,a1
	PackA
	move.b	(a1,d7),(a0)
	subq.b	#1,d6
	move.l	d6,a3
	move.w	#$fffe,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a4
	st.b	IRQ
	bra.s	start2

WBNothing:
	tst.b	BMM
	beq.s	Nothing
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Nothing
.multi
	bsr	MultiBMM
Nothing:
	moveq	#0,d7
	rts

Freak:
	move.w	#$000,$dff180
	move.w	#$fff,$dff180
	btst.b	#6,$bfe001
	bne.s	Freak
	bra	qu

Done:
	btst	#6,$bfe001
	beq	qu
	bne.s	Done

	cnop	0,4

RasterR:
	move.w	$dff006,d7
	lsr.w	#8,d7
	move.b	d7,(a0)
	rts

	cnop	0,4

WBRasterW:
	tst.b	BMM
	beq.s	RasterW
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	RasterW
.multi
	bsr	MultiBMM
RasterW:
	move.b	(a0),RasterL
	move.w	#0,$dff08a
	moveq	#0,d7
	rts

; Shadow ram, contains routine identifiers showing what each byte of
; memory is attached to.
; Numbers are used to index into routine pointers stored in two tables
; One table for read, one for write
; a1 - read/write base base	a2 - write base
; Currently:
;	0 - no action
;	1 - KROMS - $e000-$ffff
;	2 - VIC Raster Control $d012
;	3 - BROMS - $a000-$bfff
;	4 - VIC screen
;	5 - MCR $d018
;	6 - Border colour $d020
;	7 - Screen colour $d021
;	8 - KeyWrite $dc00-write
;	9 - KeyRead $dc01-read

; PRE:	a6 MUST point to SRAM base,a1-ReadTable,a2-WriteTable
; POST:	Assume ALL registers except a6 trashed!

InitSRAM:
	move.l	#8191,d0
	move.l	#$a000,d1
	move.l	#$e000,d2
.lp	move.w	#1,(a6,d1.l*2)
	move.w	#2,(a6,d2.l*2)
	addq.l	#1,d1
	addq.l	#1,d2
	dbra	d0,.lp
	move.w	#3,(2.w,a6)		;IOPort

	move.w	#$d000,d7
	moveq	#4,d1
	moveq	#46,d0
.VIClp
	move.w	d1,(a6,d7.l*2)
	addq.l	#1,d7
	addq.w	#1,d1
	dbra	d0,.VIClp
	
	move.w	#$d400,d7
	moveq	#28,d0
.SIDlp
	move.w	d1,(a6,d7.l*2)
	addq.l	#1,d7
	addq.w	#1,d1
	dbra	d0,.SIDlp
	
	move.w	#$d800,d7
	move.l	#999,d0
.COLlp
	move.w	d1,(a6,d7.l*2)
	addq.l	#1,d7
	dbra	d0,.COLlp

	move.w	#$dc00,d7
	addq.w	#1,d1
	moveq	#15,d0
.CIA1lp
	move.w	d1,(a6,d7.l*2)
	addq.l	#1,d7
	addq.w	#1,d1
	dbra	d0,.CIA1lp

	move.w	#$dd00,d7
	moveq	#15,d0
.CIA2lp
	move.w	d1,(a6,d7.l*2)
	addq.l	#1,d7
	addq.w	#1,d1
	dbra	d0,.CIA2lp

	move.w	#2040,d7
	moveq	#7,d0
.SPlp
	move.w	d1,(a6,d7.l*2)
	addq.l	#1,d7
	addq.w	#1,d1
	dbra	d0,.SPlp

	moveq	#0,d7
	moveq	#63,d0
	move.w	#$100,d1
.SDlp
	move.w	d1,(a6,d7.l*2)
	addq.l	#1,d7
	dbra	d0,.SDlp

	move.w	#$0400,d7
	move.l	#$80,d1
	move.w	#999,d0
.SCRlp
	move.w	d1,(a6,d7.l*2)
	addq.l	#1,d7
	dbra	d0,.SCRlp

	moveq	#0,d7
	move.l	#$02000200,d1
	move.w	#3999,d0
.BMlp
	add.l	d1,(a6,d7.l*2)
	addq.l	#2,d7
	dbra	d0,.BMlp

	move.l	#Nothing,d1
	move.l	#$fffe,d2
	moveq	#0,d7
.Clear
	move.l	d1,(a2,d7.l*4)
	move.l	d1,(a1,d7.l*4)
	addq.l	#1,d7
	dbra	d2,.Clear

	move.l	#IOPort,(12.w,a2)
	move.l	#DoScreen,(512+2048.w,a2)
	move.l	#DoScreen,(512.w,a2)
	move.l	#ColWrite,(2048+320.w,a2)
	move.l	#ColWrite,(320.w,a2)
	move.l	#BasicROMWrite,(4.w,a2)
	move.l	#KernalROMWrite,(8.w,a2)
	move.l	#Sprite0P,(452.w,a2)
	move.l	#Sprite1P,(456.w,a2)
	move.l	#Sprite2P,(460.w,a2)
	move.l	#Sprite3P,(464.w,a2)
	move.l	#Sprite4P,(468.w,a2)
	move.l	#Sprite5P,(472.w,a2)
	move.l	#Sprite6P,(476.w,a2)
	move.l	#Sprite7P,(480.w,a2)
	move.l	#WBSprite0P,(2048+452.w,a2)
	move.l	#WBSprite1P,(2048+456.w,a2)
	move.l	#WBSprite2P,(2048+460.w,a2)
	move.l	#WBSprite3P,(2048+464.w,a2)
	move.l	#WBSprite4P,(2048+468.w,a2)
	move.l	#WBSprite5P,(2048+472.w,a2)
	move.l	#WBSprite6P,(2048+476.w,a2)
	move.l	#WBSprite7P,(2048+480.w,a2)
	move.l	#UpdateSprites,(1024.w,a2)
	move.l	#WBUpdateSprites,(1024+2048.w,a2)

	move.l	#VCRR1,(84.w,a1)
	move.l	#RasterR,(88.w,a1)
	move.l	#ReadJOY2,(324.w,a1)
	move.l	#KeyRead,(328.w,a1)
	move.l	#Rc1TALOHI,(340.w,a1)
	move.l	#Rc1TALOHI,(344.w,a1)
	move.l	#Rc1TBLOHI,(348.w,a1)
	move.l	#Rc1TBLOHI,(352.w,a1)
	move.l	#Rc1ICR,(376.w,a1)
	move.l	#DPortAR,(388.w,a1)

	move.l	#WriteVIC,a0
	move.l	#Write1VIC,a1
	moveq	#4,d0
	move.l	#$204,d2
	moveq	#46,d1
.VICloop
	move.l	(a0)+,(a2,d0.l*4)
	move.l	(a1)+,(a2,d2.l*4)
	addq.l	#1,d0
	addq.l	#1,d2
	dbra	d1,.VICloop

	move.l	#WriteSID,a0
	move.l	#Write1SID,a1
	moveq	#28,d1
.SIDloop
	move.l	(a0)+,(a2,d0.l*4)
	move.l	(a1)+,(a2,d2.l*4)
	addq.l	#1,d0
	addq.l	#1,d2
	dbra	d1,.SIDloop

	move.l	#WriteCIA1,a0
	move.l	#Write1CIA1,a1
	moveq	#81,d0
	move.l	#$251,d2
	moveq	#15,d1
.CIA1loop
	move.l	(a0)+,(a2,d0.l*4)
	move.l	(a1)+,(a2,d2.l*4)
	addq.l	#1,d0
	addq.l	#1,d2
	dbra	d1,.CIA1loop

	move.l	#WriteCIA2,a0
	move.l	#Write1CIA2,a1
	moveq	#15,d1
.CIA2loop
	move.l	(a0)+,(a2,d0.l*4)
	move.l	(a1)+,(a2,d2.l*4)
	addq.l	#1,d0
	addq.l	#1,d2
	dbra	d1,.CIA2loop
	rts

	cnop	0,4
WBWc1ICR:
	tst.b	BMM
	beq.s	Wc1ICR
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Wc1ICR
.multi
	bsr	MultiBMM
Wc1ICR:
	move.b	(a0),$BFDD00		; CIA B ICR
	moveq	#0,d7
	rts

Rc1ICR:
	move.b	$BFDD00,(a0)
	tst.b	CIASkip
	beq.s	.over
	bclr	#1,(a0)
	moveq	#0,d7
	rts
.over
	tst.b	SerTalk
	beq.s	.over1
	tst.b	IRQ
	bne.s	.over1
	subq.b	#1,CIACount
	bne.s	.over1
	bset	#1,(a0)
	tst.b	IOError
	bne.s	.over2
	st.b	CIASkip
	move.b	#4,CountP
.over1
	moveq	#0,d7
	rts
.over2
	subq.b	#1,CIACount2
	bne.s	.over3
	move.b	#0,BufferP
	move.b	#0,SerTalk
	move.b	#2,CIACount
	move.b	#2,CIACount2
	move.b	#0,IOError
	lea	inbuff,a1
	add.l	bufflen,a1
	moveq	#15,d5
	moveq	#0,d7
.clear
	move.b	d7,(a1)+
	dbra	d5,.clear
	rts
.over3
	move.b	#4,CountP
	move.b	#2,CIACount
	rts

WBWc1CRA:
	tst.b	BMM
	beq.s	Wc1CRA
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Wc1CRA
.multi
	bsr	MultiBMM
Wc1CRA:
	move.b	(a0),d7
	and.w	#$7f,d7
	move.b	d7,$BFDE00
	rts

WBWc1CRB:
	tst.b	BMM
	beq.s	Wc1CRB
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Wc1CRB
.multi
	bsr	MultiBMM
Wc1CRB:
	move.b	(a0),$BFDF00
	moveq	#0,d7
	rts

WBWc1TALO
	tst.b	BMM
	beq.s	Wc1TALO
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Wc1TALO
.multi
	bsr	MultiBMM
Wc1TALO:
	move.b	(a0),CIA1TALO
	move.w	CIA1TAHI,d7
	mulu	#7,d7
	divu	#10,d7
	move.b	d7,$BFD400	; Write TALO
	lsr.w	#8,d7
	move.b	d7,$BFD500	; Write TAHI
	moveq	#0,d7
	rts


Rc1TALOHI:
	move.b	$BFD500,d7
	lsl.l	#8,d7
	move.b	$BFD400,d7
	mulu	#10,d7
	divu	#7,d7
	move.b	d7,(a0)		; Write TALO or TAHI
	moveq	#0,d7
	rts

WBWc1TAHI:
	tst.b	BMM
	beq.s	Wc1TAHI
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Wc1TAHI
.multi
	bsr	MultiBMM
Wc1TAHI:
	move.b	(a0),CIA1TAHI
	move.w	CIA1TAHI,d7
	mulu	#7,d7
	divu	#10,d7
	move.b	d7,$BFD400	; Write TALO
	lsr.w	#8,d7
	move.b	d7,$BFD500	; Write TAHI
	moveq	#0,d7
	rts

WBWc1TBLO:
	tst.b	BMM
	beq.s	Wc1TBLO
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Wc1TBLO
.multi
	bsr	MultiBMM
Wc1TBLO:
	move.b	(a0),CIA1TBLO
	move.w	CIA1TBHI,d7
	mulu	#7,d7
	divu	#10,d7
	move.b	d7,$BFD600	; Write TBLO
	lsr.w	#8,d7
	move.b	d7,$BFD700	; Write TBHI
	moveq	#0,d7
	rts


Rc1TBLOHI:
	move.b	$BFD700,d7
	lsl.l	#8,d7
	move.b	$BFD600,d7
	mulu	#10,d7
	divu	#7,d7
	move.b	d7,(a0)		; Write TBLO or TBHI
	moveq	#0,d7
	rts

WBWc1TBHI:
	tst.b	BMM
	beq.s	Wc1TBHI
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Wc1TBHI
.multi
	bsr	MultiBMM
Wc1TBHI:
	move.b	(a0),CIA1TBHI
	move.w	CIA1TBHI,d7
	mulu	#7,d7
	divu	#10,d7
	move.b	d7,$BFD600	; Write TBLO
	lsr.w	#8,d7
	move.b	d7,$BFD700	; Write TBHI
	moveq	#0,d7
	rts

KernalROMWrite:
	move.w	a0,d4
	and.w	#$1fff,d4
	move.b	(a0),([KernalRAM],d4.l)
	tst.b	KernalROM
	beq.s	.over
	move.b	($4000.w,a0),(a0)
.over
	moveq	#0,d7
	rts

BasicROMWrite:
	move.w	a0,d4
	and.w	#$1fff,d4
	move.b	(a0),([BasicRAM],d4.l)
	tst.b	BasicROM
	beq.s	.over
	move.b	($6000.w,a0),(a0)
.over
	moveq	#0,d7
	rts

WBOsci3:
	tst.b	BMM
	beq.s	Osci3
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Osci3
.multi
	bsr	MultiBMM
Osci3:
	move.w	$dff006,d7	;pseudo random #
	lsr.w	#8,d7
	move.b	d7,(a0)
	rts

IOPort:
	move.b	(a0),d5
	btst	#0,d5
	bne.s	.BasicROMIN
	tst.b	BasicROM
	beq.s	.leave
	bra.s	.BasicRAMIN
.BasicROMIN
	tst.b	BasicROM
	bne.s	.leave
	move.w	#$a000,d6		;Copy ROM to RAM
	move.l	d6,a5
	lea	($6000.w,a5),a1
	move.w	#1023,d6
.loop
	move.l	(a1)+,(a5)+
	move.l	(a1)+,(a5)+
	dbra	d6,.loop
	st.b	BasicROM
	bra.s	.leave
.BasicRAMIN
	move.l	BasicRAM,a1		;copy Hidden RAM to RAM
	move.w	#$a000,d6
	move.l	d6,a5
	move.w	#1023,d6
.loop1	
	move.l	(a1)+,(a5)+
	move.l	(a1)+,(a5)+
	dbra	d6,.loop1
	sf.b	BasicROM
.leave
	btst	#1,d5
	bne.s	.KernalROMIN
	tst.b	KernalROM
	beq.s	.leave1
	bra.s	.KernalRAMIN
.KernalROMIN
	tst.b	KernalROM
	bne.s	.leave1
	move.w	#$e000,d6		;Copy ROM to RAM
	move.l	d6,a5
	lea	($4000.w,a5),a1
	move.w	#1023,d6
.loop2
	move.l	(a1)+,(a5)+
	move.l	(a1)+,(a5)+
	dbra	d6,.loop2
	st.b	KernalROM
	bra.s	.leave1
.KernalRAMIN
	move.l	KernalRAM,a1		;copy Hidden RAM to RAM
	move.w	#$e000,d6
	move.l	d6,a5
	move.w	#1023,d6
.loop3
	move.l	(a1)+,(a5)+
	move.l	(a1)+,(a5)+
	dbra	d6,.loop3
	sf.b	KernalROM
.leave1
	move.b	d5,d6
	and.w	#3,d6
	beq	.over6
	tst.b	HiddenIO
	beq.s	.over7
	movem.l	a2/a3,-(sp)
	move.l	CharRAM,a1
	move.l	ShadowCopy,a0
	move.l	a6,a2
	add.l	#$1a000,a2
	move.l	IORAM,a3
	move.w	#$d000,d6
	move.l	d6,a5
	move.w	#1023,d6
.loop7
	move.l	(a0)+,(a2)+
	move.l	(a5),(a3)+
	move.l	(a1)+,(a5)+
	move.l	(a0)+,(a2)+
	dbra	d6,.loop7
	sf.b	HiddenIO
	move.l	#0,CharROMSwitch
	movem.l	(sp)+,a2/a3
.over7
	btst	#2,d5
	bne.s	.CharOUT
	tst.b	CharROM
	beq	.over5
	bra.s	.over4
.CharOUT
	tst.b	CharROM
	bne	.over5
	move.l	a2,-(sp)
	move.l	CharRAM,a1
	move.l	ShadowCopy,a0
	move.l	a6,a2
	add.l	#$1a000,a2
	move.w	#$d000,d6		;Copy VIC/SID/CIA's back to RAM
	move.l	d6,a5			;Copy Shadow RAM back
	move.w	#1023,d6
.loop4
	move.l	(a0)+,(a2)+
	move.l	(a1)+,(a5)+
	move.l	(a0)+,(a2)+
	dbra	d6,.loop4
	st.b	CharROM
	move.l	#0,CharROMSwitch
	move.l	(sp)+,a2
	bra.s	.over5
.over4
	movem.l	a2/a3,-(sp)
	move.l	ShadowCopy,a2
	move.l	a6,a3
	add.l	#$1a000,a3
	moveq	#0,d4
	move.l	CROMAddy,a1		;Copy VIC/SID/CIA's to Hidden RAM
	move.l	CharRAM,a0		;Copy Character ROM to RAM
	move.w	#$d000,d6		;Copy Shadow RAM for IO to Memory
	move.l	d6,a5			;Clear Shadow RAM
	move.w	#1023,d6
.loop5
	move.l	(a3),(a2)+
	move.l	d4,(a3)+
	move.l	(a5),(a0)+
	move.l	(a1)+,(a5)+
	move.l	(a3),(a2)+
	move.l	d4,(a3)+
	dbra	d6,.loop5
	sf.b	CharROM
	move.l	#$c000,CharROMSwitch
	movem.l	(sp)+,a2/a3
.over5
	moveq	#0,d7
	jmp	start2
.over6
	movem.l	a2/a3,-(sp)		;
	move.w	#$d000,d6
	move.l	d6,a5
	move.l	ShadowCopy,a2
	move.l	a6,a3
	add.l	#$1a000,a3		;$d000*2
	move.l	CharRAM,a0
	move.l	IORAM,a1
	moveq	#0,d4
	move.w	#1023,d6
.loop6
	move.l	(a3),(a2)+
	move.l	d4,(a3)+
	move.l	(a5),(a0)+		;copy VIC to tempRAM
	move.l	(a1)+,(a5)+		;copy Hidden RAM to RAM
	move.l	(a3),(a2)+
	move.l	d4,(a3)+	
	dbra	d6,.loop6
	st.b	HiddenIO
	move.l	#$c000,CharROMSwitch
	movem.l	(sp)+,a2/a3
	moveq	#0,d7
	jmp	start2

WBInterruptFRW:
	tst.b	BMM
	beq.s	InterruptFRW
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	InterruptFRW
.multi
	bsr	MultiBMM
InterruptFRW:
	move.b	IntFRTemp,d6
	move.b	(a0),d5
	eor.b	#255,d5
	and.b	d5,d6
	move.b	d6,(a0)
	moveq	#0,d7
	rts

WBMCR:
	tst.b	BMM
	beq.s	MCR
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	MCR
.multi
	bsr	MultiBMM
MCR:
	moveq	#0,d5
	move.w	VICBank,d5
	move.b	(a0),d6
	and.w	#14,d6

	cmp.w	#$4000,d5
	beq.s	.norom
	cmp.w	#$c000,d5
	beq.s	.norom

	cmp.b	#4,d6
	beq.s	.userom
	cmp.b	#6,d6
	beq.s	.userom
.norom
	move.l	d5,d4
	bra.s	.over5
.userom
	move.l	#$13000,d4
.over5
	lsl.w	#8,d6
	lsl.w	#2,d6
	add.l	d6,d4
	move.l	d4,CROMAddy
	
	move.l	#0,CharAddress
	and.w	#8192,d6		;Bit-Map must be on 8192 boundary
	beq.s	.noswitch
	cmp.w	#$8000,VICBank
	bne.s	.wrongbank
	move.l	#$b000,CharAddress	;Bank 2/upper map
	bra.s	.noswitch
.wrongbank
	cmp.w	#$c000,VICBank
	bne.s	.noswitch
	move.l	#$9000,CharAddress	;Bank3/upper map
.noswitch
	add.w	VICBank,d6
	add.l	d6,CharAddress		;Actual Address of BitMap Data

	moveq	#0,d5
	move.w	MCRCharLast,d5
	move.w	d6,MCRCharLast
	move.w	d6,d7
	move.w	#3999,d6
	move.l	#$02000200,d4
.loop
	sub.l	d4,(a6,d5.l*2)
	add.l	d4,(a6,d7.l*2)
	addq.w	#2,d5
	addq.w	#2,d7
	dbra	d6,.loop
.over2
	move.b	(a0),d6
	and.w	#240,d6
	lsl.w	#6,d6
	add.w	VICBank,d6
	move.w	MCRLast,d5
	move.w	d6,MCRLast
	move.l	d6,ScreenAddress
	move.w	d6,d7
	
	move.w	#499,d6
	move.l	#$00800080,d4
.lp
	sub.l	d4,(a6,d5.l*2)
	add.l	d4,(a6,d7.l*2)
	addq.w	#2,d5
	addq.w	#2,d7
	dbra	d6,.lp
	add.l	#16,d5
	add.l	#16,d7
	moveq	#$71,d4
	move.w	#7,d6
.splp
	sub.w	d4,(a6,d5.l*2)
	add.w	d4,(a6,d7.l*2)
	addq.w	#1,d5
	addq.w	#1,d7
	addq.w	#1,d4
	dbra	d6,.splp

	moveq	#0,d4

	tst.b	BMM
	beq.s	.over3
	tst.b	MCM
	beq.s	.over4
	bra	RefreshMCBMM
.over4
	bra	RefreshBMM
.over3
	tst.b	MCM
	beq.s	.over1
	bra	RefreshMCM
.over1
	tst.b	ECM
	beq.s	.over
	bra	RefreshECM
.over
	bra	RefreshT

	cnop	0,4

WBBorderCol:
	tst.b	BMM
	beq.s	BorderCol
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	BorderCol
.multi
	bsr	MultiBMM
BorderCol:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),d5
	move.w	d5,$dff180
	move.w	d5,MyCopList+2
	rts

	cnop	0,4

WBScreenCol:
	tst.b	BMM
	beq.s	ScreenCol
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	ScreenCol
.multi
	bsr	MultiBMM
ScreenCol:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),d5
	move.w	d5,$dff182
	move.w	d5,MyCopList+6
	rts

WBScreenCol1:
	tst.b	BMM
	beq.s	ScreenCol1
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	ScreenCol1
.multi
	bsr	MultiBMM
ScreenCol1:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),d5
	move.w	d5,$dff186
	move.w	d5,Extra+2
	rts

WBScreenCol2:
	tst.b	BMM
	beq.s	ScreenCol2
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	ScreenCol2
.multi
	bsr	MultiBMM
ScreenCol2:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),d5
	move.w	d5,$dff18a
	move.w	d5,Extra+6
	rts

WBScreenCol3:
	tst.b	BMM
	beq.s	ScreenCol3
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	ScreenCol3
.multi
	bsr	MultiBMM
ScreenCol3:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),d5
	move.w	d5,$dff192
	move.w	d5,Extra+10
	rts

	cnop	0,4

Do1541:
	moveq	#0,d7
	move.b	BufferP,d7
	lea	Buffer,a5
	tst.b	IOFlag
	bne	.writedata
	move.b	SerData,(a5,d7.l)
	addq.b	#1,BufferP
	move.w	-1(a5,d7.l),d4
	cmp.w	#$2861,d4
	beq.s	.Save		;IOFlag=-1
	cmp.w	#$4860,d4
	beq.s	.Load		;IOFlag=0
	cmp.w	#$e03f,d4
	beq	.CloseFile
	cmp.w	#$ef3f,d4
	beq	.CloseFile
	cmp.w	#$243f,d4
	beq	DoDirectory
	cmp.w	#$486f,d4
	beq	ChannelI15
	cmp.b	#$3f,d4
	beq.s	.Name
.over
	rts
.Name
	lea	inbuff,a1
	add.l	bufflen,a1
	addq.l	#2,a5
.loop1
	move.b	(a5)+,(a1)+
	cmp.b	#$3f,(a5)
	bne.s	.loop1
	move.b	#0,BufferP
	rts
.Save
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	#1006,d2
	move.l	#inbuff,d1
	move.l	dosbase,a6
	jsr	_LVOOpen(a6)
	move.l	d0,file64hd
	st.b	IOFlag
	movem.l	(sp)+,d0-d7/a0-a6
	rts
.Load
	tst.b	DIR
	beq.s	.NoDir
	sf.b	IOFlag
	bra	ReadByte
.NoDir
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	#1005,d2
	move.l	#inbuff,d1
	move.l	dosbase,a6
	jsr	_LVOOpen(a6)
	bne.s	.FileFound
	st.b	IOError
	sf.b	IOFlag
	move.b	#2,DriveST
	movem.l	(sp)+,d0-d7/a0-a6
	rts
.FileFound
	move.l	d0,file64hd
	sf.b	IOFlag
	sf.b	IOError
	movem.l	(sp)+,d0-d7/a0-a6
	bsr	GetLength
	bsr	ReadByte
	rts
.CloseFile
	tst.b	DIR
	beq.s	.NoDir2
	sf.b	DIR
	bra.s	.AllDone
.NoDir2
	tst.b	ReadST
	beq.s	.NoDir1
	sf.b	ReadST
	move.b	#0,BufferP
	move.b	#0,SerData
	move.l	#0,CurrentLength
	rts
.NoDir1
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	dosbase,a6
	move.l	file64hd,d1
.loop
	jsr	_LVOClose(a6)
	beq.s	.loop
	movem.l	(sp)+,d0-d7/a0-a6
.AllDone
	move.b	#0,BufferP
	move.b	#0,SerData
	move.l	#0,CurrentLength
	sf.b	IOError
	lea	inbuff,a1
	add.l	bufflen,a1
	moveq	#15,d5
	moveq	#0,d4
.clear
	move.b	d4,(a1)+
	dbra	d5,.clear
	rts

.writedata
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	dosbase,a6
	move.l	file64hd,d1
	btst	#3,d5
	bne.s	.donewrite
	moveq	#0,d2
	move.b	SerData,d2
	jsr	_LVOFPutC(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts
.donewrite
	sf.b	IOFlag
	movem.l	(sp)+,d0-d7/a0-a6
	rts

GetLength:
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	dosbase,a6
	move.l	#inbuff,d1
	moveq	#-2,d2
	jsr	_LVOLock(a6)
	move.l	d0,locksav
	move.l	d0,d1
	move.l	#FileInfo,d2
	jsr	_LVOExamine(a6)
	move.l	FileInfo+124,FileLength
	move.l	dosbase,a6
	move.l	locksav,d1
	jsr	_LVOUnLock(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts

ChannelI15:
	st.b	ReadST
	move.b	DriveST,d7
	bne.s	.OtherMessage	
	move.l	#1,DriveMP		;Power On Message
	move.l	#26,FileLength
	move.b	#0,BufferP
	move.b	(DriveMessage),LoadByte
	move.b	#1,DriveST
	rts
.OtherMessage
	cmp.b	#1,d7
	beq.s	.ok
	moveq	#40,d7			;File not Found
	move.l	#23,FileLength
	move.b	#0,BufferP
	move.b	(DriveMessage,d7.l),LoadByte
	addq.l	#1,d7
	move.l	d7,DriveMP
	move.b	#1,DriveST
	rts
.ok
	moveq	#27,d7			;OK message
	move.l	#12,FileLength
	move.b	#0,BufferP
	move.b	(DriveMessage,d7.l),LoadByte
	addq.l	#1,d7
	move.l	d7,DriveMP
	rts

DoDirectory:
	moveq	#0,d7
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	Directory,a2
	move.l	a2,DirTemp
	move.l	dosbase,a6
	move.l	#inbuff,d1
	moveq	#-2,d2
	jsr	_LVOLock(a6)
	move.l	d0,locksav
	move.l	d0,d1
	move.l	#FileInfo,d2
	jsr	_LVOExamine(a6)
	move.l	d2,a1
	move.l	#$01041f08,(a2)+
	move.l	#$00001222,(a2)+
	addq.l	#8,a1
	moveq	#15,d2
.loop
	move.b	(a1)+,d0
	beq.s	.loop1
	cmp.b	#64,d0
	blo.s	.lp
	and.b	#$5f,d0
.lp
	move.b	d0,(a2)+
	dbra	d2,.loop
.loop1
	move.b	#32,(a2)+
	dbf	d2,.loop1

	move.b	#34,(a2)+
	move.l	#" 00 ",(a2)+
	move.w	#"2A",(a2)+
	move.b	#0,(a2)+
	move.w	#$3f08,d4
	move.w	d4,(a2)+
.main
	move.l	#FileInfo,d2
	move.l	locksav,d1
	jsr	_LVOExNext(a6)
	tst.l	d0
	beq	.end
	move.l	d2,a1
	move.l	124(a1),d1
	lsr.l	#8,d1
	addq.l	#1,d1
	move.b	d1,(a2)+
	ror.w	#8,d1
	move.b	d1,(a2)+
	ror.w	#8,d1
	cmp.w	#100,d1
	bhs.s	.ov1
	move.b	#32,(a2)+
	cmp.w	#10,d1
	bhs.s	.ov1
	move.b	#32,(a2)+
.ov1
	move.w	#$2022,(a2)+

	move.l	#FileInfo,a1
	addq.l	#8,a1
	moveq	#16,d2
.loop3
	move.b	(a1)+,d0
	beq.s	.ov
	cmp.b	#64,d0
	blo.s	.lp1
	and.b	#$5f,d0
.lp1
	move.b	d0,(a2)+
	dbra	d2,.loop3
.ov
	move.b	#34,(a2)+
.loop2
	move.b	#32,(a2)+
	dbf	d2,.loop2

	move.w	#"PR",(a2)+
	move.l	#$47202020,(a2)+
	move.w	#$2000,(a2)+

	ror.w	#8,d4
	add.w	#$20,d4
	ror.w	#8,d4

	move.w	d4,(a2)+
	
	bra	.main
.end
	move.l	dosbase,a6
	move.l	locksav,d1
	jsr	_LVOUnLock(a6)

	move.w	#0,(a2)+
	move.l	#"BLOC",(a2)+
	move.l	#"KS F",(a2)+
	move.l	#"REE ",(a2)+
	move.l	#0,(a2)+

	sub.l	#$0108,d4
	ror.w	#8,d4
	add.l	#12,d4
	move.l	d4,FileLength
	movem.l	(sp)+,d0-d7/a0-a6
	st.b	DIR
	move.b	#0,BufferP
	rts

ReadByte:
	tst.b	DIR
	beq.s	.over
	move.b	([DirTemp]),LoadByte
	addq.l	#1,DirTemp
	rts
.over
	tst.b	IOError
	bne.s	.over1
	tst.b	ReadST
	beq.s	.Load
	move.l	DriveMP,d5
	move.b	(DriveMessage,d5.l),LoadByte
	addq.l	#1,DriveMP
	rts
.Load
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	file64hd,d1
	move.l	dosbase,a6
	jsr	_LVOFGetC(a6)
	move.b	d0,LoadByte
	movem.l	(sp)+,d0-d7/a0-a6
.over1
	rts

DPortAR:
	moveq	#0,d7
	tst.b	EOITime
	beq.s	.Listener
	subq.b	#1,CountP
	bne.s	.NoData
	bchg	#7,(a0)
	move.b	#4,CountP
.NoData
	rts
.Listener
	tst.b	SerTalk
	beq.s	.NoData
	subq.b	#1,CountP
	bne.s	.NoData
	btst	#5,(a0)
	bne.s	.Skip
	bchg	#6,(a0)
	beq.s	.SendData
	tst.b	Counter
	bne.s	.over
	tst.b	CIACount
	bne.s	.over1
	sf.b	CIASkip
	sf.b	SerTalk
	move.b	#2,CIACount
	rts
.over1
	move.b	#8,Counter
	move.b	#4,CountP
	rts
.over
	move.b	#2,CountP
	rts
.Skip
	bchg	#6,(a0)
	move.b	#3,CountP
	rts
.SendData
	lea	LoadByte,a1
	move.b	(a1),d5
	ror.b	#1,d5
	bcs.s	.SendHI
	bclr	#7,(a0)
	move.b	d5,(a1)
	subq.b	#1,Counter
	bne.s	.Skip1
	addq.l	#1,CurrentLength
	bsr	ReadByte
	move.l	FileLength,d5
	subq.l	#1,d5
	cmp.l	CurrentLength,d5
	bne.s	.Skip1
	sf.b	CIASkip
	move.b	#2,CountP
	rts
.Skip1
	move.b	#2,CountP
	rts
.SendHI
	bset	#7,(a0)
	move.b	d5,(a1)
	subq.b	#1,Counter
	bne.s	.Skip2
	addq.l	#1,CurrentLength
	bsr	ReadByte
	move.l	FileLength,d5
	subq.l	#1,d5
	cmp.l	CurrentLength,d5
	bne.s	.Skip2
	sf.b	CIASkip
	move.b	#2,CountP
	rts
.Skip2
	move.b	#2,CountP
	rts

WBDPortAW:
	tst.b	BMM
	beq.s	DPortAW
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	DPortAW
.multi
	bsr	MultiBMM
DPortAW:
	moveq	#0,d7
	move.b	(a0),d5
	tst.b	LRData
	beq.s	.NoData
	btst	#4,d5
	beq.s	.Skip
	sf.b	EOITime
	bra	.NoTRS
.Skip
	tst.b	SerCLK
	bne.s	.Skip0
	sf.b	EOITime		;corrects problem
	sf.b	LRData		;caused by $ee0d
	bra	.NoTRS1
.Skip0
	sf.b	SerCLK
	move.b	SerData,d7	;receiving data
	btst	#5,d5
	bne.s	.JustShift	;Invert The bits
	lsr.b	#1,d7
	bset	#7,d7
	move.b	d7,SerData
	subq.b	#1,Counter
	bne	.NoTRS1
	sf.b	LRData
	bsr	Do1541
	bra	.NoTRS1
.JustShift
	lsr.b	#1,d7
	move.b	d7,SerData
	subq.b	#1,Counter
	bne	.NoTRS1
	sf.b	LRData
	bsr	Do1541
	bra	.NoTRS1
.NoData
	btst	#4,d5
	beq.s	.Other
	tst.b	SerCLK
	bne	.NoTRS1
	bclr	#7,(a0)		;listener data accepted
	move.b	#8,Counter
	bra	.NoTRS
.Other
	tst.b	SerCLK
	beq.s	.NoTRS1
	sf.b	SerCLK
	tst.b	SerTalk
	bne.s	.NoTRS1
	btst	#5,d5
	beq.s	.Skip1		;Conditions for Listen -> Talker
	bclr	#6,(a0)		;Device ack it is now talker
	st.b	SerTalk
	tst.b	IOError
	beq.s	.noerr
	sf.b	CIASkip
	move.b	#4,CountP
	bra.s	.NoTRS1
.noerr
	st.b	CIASkip
	move.b	#4,CountP
	bra.s	.NoTRS1
.Skip1
	st.b	LRData		;Listener Ready For Data
	st.b	EOITime
	move.b	#5,CountP
	bset	#7,(a0)
	bra.s	.NoTRS1
.NoTRS
	st.b	SerCLK
.NoTRS1
	and.l	#3,d5
	eor.b	#3,d5
	lsl.w	#8,d5
	lsl.w	#6,d5
	move.w	VICBank,d7
	move.w	d7,OldVICBank
	move.w	d5,VICBank
	cmp.w	d5,d7
	bne.s	.change
	rts
.change
	move.b	(-3304.w,a0),d6		;$d018
	and.w	#14,d6

	cmp.w	#$4000,d5
	beq.s	.norom
	cmp.w	#$c000,d5
	beq.s	.norom

	cmp.b	#4,d6
	beq.s	.userom
	cmp.b	#6,d6
	beq.s	.userom
.norom
	move.l	d5,d4
	bra.s	.over2
.userom
	move.l	#$13000,d4
.over2
	lsl.w	#8,d6
	lsl.w	#2,d6
	add.l	d6,d4
	move.l	d4,CROMAddy

	move.l	ScreenAddress,d4		;old screen Address
	and.l	#$ffff,d4
	lsl.l	#1,d4
	move.l	a6,a1
	add.l	d4,a1
	lsr.l	#1,d4
	sub.l	d7,d4
	add.l	d5,d4
	move.w	d4,MCRLast
	move.w	d4,d6
	move.l	d6,ScreenAddress
	lsl.l	#1,d4
	move.l	a6,a5
	add.l	d4,a5
	move.w	#499,d6
	move.l	#$00800080,d4
.loop
	sub.l	d4,(a1)+
	add.l	d4,(a5)+
	dbra	d6,.loop
	lea	(32.w,a1),a1
	lea	(32.w,a5),a5
	moveq	#$71,d4
	move.w	#7,d6
.sploop
	sub.w	d4,(a1)+
	add.w	d4,(a5)+
	addq.l	#1,d4
	dbra	d6,.sploop

	moveq	#0,d4
	move.l	#0,CharAddress
	move.w	MCRCharLast,d6			;old Bit-Map addy+bank
	beq.s	.noswitch
	cmp.w	#$8000,d5
	bne.s	.wrongbank
	move.l	#$b000,CharAddress
	bra.s	.noswitch
.wrongbank
	cmp.w	#$c000,d6
	bne.s	.noswitch
	move.l	#$9000,CharAddress
.noswitch
	move.w	d6,d4
	lsl.l	#1,d4
	move.l	a6,a1
	add.l	d4,a1
	sub.w	d7,d6
	add.w	d5,d6
	move.w	d6,MCRCharLast
	add.l	d6,CharAddress
	moveq	#0,d4
	move.w	d6,d4
	lsl.l	#1,d4
	move.l	a6,a5
	add.l	d4,a5
	move.w	#3999,d6
	move.l	#$02000200,d4
.loop1
	sub.l	d4,(a1)+
	add.l	d4,(a5)+
	dbra	d6,.loop1

	moveq	#0,d4
	tst.b	BMM
	beq.s	.over3
	tst.b	MCM
	beq.s	.over4
	bra	RefreshMCBMM
.over4
	bra	RefreshBMM
.over3
	tst.b	MCM
	beq.s	.over1
	bra	RefreshMCM
.over1
	tst.b	ECM
	beq.s	.over
	bra	RefreshECM
.over
	bra	RefreshT

VCRR1:
	moveq	#0,d7
	btst	#0,$dff004
	beq.s	.unset
	bset	#7,(a0)
	rts
.unset
	bclr	#7,(a0)
	rts

WBVCRW1
	tst.b	BMM
	beq.s	VCRW1
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	VCRW1
.multi
	bsr	MultiBMM
VCRW1:
	moveq	#0,d7
	move.b	(a0),d7
	bmi.s	.set
	move.w	#0,$dff02a	;vposw
	bra.s	.main
.set
	move.w	#1,$dff02a	
.main
	btst	#6,d7
	bne	.SetECM
	btst	#5,d7
	bne	.SetBMM
	tst.b	BMM
	beq.s	.over1
	tst.b	MCM
	beq.s	.normal
	move.l	#MCMWrite,(512.w,a2)
	move.l	#MCMWrite,(512+2048.w,a2)
	move.l	#MCMColWrite,(320.w,a2)
	move.l	#Nothing,(2048.w,a2)
	sf.b	BMM
	bra	RefreshMCM
.normal
	move.l	#ColWrite,(320.w,a2)
	move.l	#DoScreen,(512.w,a2)
	move.l	#DoScreen,(512+2048.w,a2)
	move.l	#Nothing,(2048.w,a2)
	sf.b	BMM
	bra	RefreshT
.over1
	tst.b	ECM
	beq.s	.over
	move.l	#DoScreen,(512.w,a2)
	move.l	#DoScreen,(512+2048.w,a2)
	move.l	#ColWrite,(320.w,a2)
	sf.b	ECM
	bra	RefreshT
.over
	rts
.SetECM
	move.l	#DoECM,(512.w,a2)
	move.l	#DoECM,(512+2048.w,a2)
	move.l	#ECMColWrite,(320.w,a2)
	st.b	ECM
	bra	RefreshECM
.SetBMM
	tst.b	MCM
	bne.s	.multi
	move.l	#Nothing,(320.w,a2)
	move.l	#BMMColour,(512.w,a2)
	move.l	#BMMColour,(512+2048.w,a2)
	move.l	#MonoBMM,(2048.w,a2)
	st.b	BMM
	bra	RefreshBMM
.multi
	move.l	#MBMMColWrite,(320.w,a2)
	move.l	#MBMMColour,(512.w,a2)
	move.l	#MBMMColour,(512+2048.w,a2)
	move.l	#MultiBMM,(2048.w,a2)
	st.b	BMM
	bra	RefreshMCBMM

WBVCRW2:
	tst.b	BMM
	beq.s	VCRW2
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	VCRW2
.multi
	bsr	MultiBMM
VCRW2:
	moveq	#0,d7
	move.b	(a0),d7
	btst	#4,d7
	bne.s	.SetMCM
	tst.b	MCM
	beq.s	.over
	tst.b	BMM
	beq.s	.over2
	move.l	#Nothing,(320.w,a2)
	move.l	#BMMColour,(512.w,a2)
	move.l	#BMMColour,(512+2048.w,a2)
	move.l	#MonoBMM,(2048.w,a2)
	sf.b	MCM
	bra	RefreshBMM
.over2
	move.l	#DoScreen,(512.w,a2)
	move.l	#DoScreen,(512+2048.w,a2)
	move.l	#ColWrite,(320.w,a2)
	sf.b	MCM
	bra	RefreshT
.over
	rts
.SetMCM
	tst.b	BMM
	beq.s	.over1
	move.l	#MBMMColWrite,(320.w,a2)
	move.l	#MBMMColour,(512.w,a2)
	move.l	#MBMMColour,(512+2048.w,a2)
	move.l	#MultiBMM,(2048.w,a2)
	st.b	MCM
	bra	RefreshMCBMM
.over1
	move.l	#MCMWrite,(512.w,a2)
	move.l	#MCMWrite,(512+2048.w,a2)
	move.l	#MCMColWrite,(320.w,a2)
	move.l	#Nothing,(2048.w,a2)
	st.b	MCM
	bra	RefreshMCM

RefreshT:
	movem.l	a2-a4/d3,-(sp)
	move.l	ScreenAddress,a0	;screen
	move.w	#$d800,d6
	move.l	d6,a1			;colour
	add.l	CharROMSwitch,a1
	move.l	CROMAddy,a2
	lea	TextTable,a4
	
	move.w	ScrLUT,a5
	add.l	BPL2Address,a5		;bitplane
	moveq	#24,d3
.loop2
	moveq	#39,d7
.loop1
	moveq	#0,d5
	move.b	(a0)+,d5
	lea	(a2,d5.l*8),a3		;char data

	move.b	(a1)+,d4
	and.w	#15,d4

	move.w	#7,d6
.loop
	move.b	(a3)+,d5
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a4,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop
	lea	(-319.w,a5),a5
	dbra	d7,.loop1
	lea	(280.w,a5),a5
	dbra	d3,.loop2
	movem.l	(sp)+,a2-a4/d3
	moveq	#0,d7
	rts

RefreshECM:
	movem.l	a2-a4/d2-d3,-(sp)
	move.l	ScreenAddress,a0
	move.w	#$d800,d6
	move.l	d6,a1
	add.l	CharROMSwitch,a1
	move.l	CROMAddy,a2
	lea	TextTable,a4
	
	move.w	ScrLUT,a5
	add.l	BPL2Address,a5
	moveq	#24,d3
.loop2
	moveq	#39,d7
.loop1
	move.w	#7,d6

	move.b	(a0)+,d5
	bmi	.bit7
	btst	#6,d5
	bne	.bit6
	
	and.w	#63,d5
	lea	(a2,d5.l*8),a3

	move.b	(a1)+,d4
	and.w	#15,d4

.loop
	move.b	(a3)+,d5
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a4,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop
	lea	(-319.w,a5),a5
	dbra	d7,.loop1
	lea	(280.w,a5),a5
	dbra	d3,.loop2
	movem.l	(sp)+,a2-a4/d2-d3
	moveq	#0,d7
	rts

.bit7
	btst	#6,d5
	bne	.bit76

	and.w	#63,d5
	lea	(a2,d5.l*8),a3

	move.b	(a1)+,d4
	and.w	#15,d4

.loop7
	move.b	(a3)+,d5
	move.b	d5,d2
	eor.b	#255,d2
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a4,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	or.b	d5,d2
	move.b	d2,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop7
	lea	(-319.w,a5),a5
	dbra	d7,.loop1
	lea	(280.w,a5),a5
	dbra	d3,.loop2
	movem.l	(sp)+,a2-a4/d2-d3
	moveq	#0,d7
	rts

.bit6
	and.w	#63,d5
	lea	(a2,d5.l*8),a3

	move.b	(a1)+,d4
	and.w	#15,d4

.loop6
	move.b	(a3)+,d5
	move.b	d5,d2
	eor.b	#255,d2
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a4,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	or.b	d5,d2
	move.b	d2,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop6
	lea	(-319.w,a5),a5
	dbra	d7,.loop1
	lea	(280.w,a5),a5
	dbra	d3,.loop2
	movem.l	(sp)+,a2-a4/d2-d3
	moveq	#0,d7
	rts

.bit76
	and.w	#63,d5
	lea	(a2,d5.l*8),a3

	move.b	(a1)+,d4
	and.w	#15,d4

.loop76
	move.b	(a3)+,d5
	move.b	d5,d2
	eor.b	#255,d2
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a4,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
 	or.b	d5,d2
	move.b	d2,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop76
	lea	(-319.w,a5),a5
	dbra	d7,.loop1
	lea	(280.w,a5),a5
	dbra	d3,.loop2
	movem.l	(sp)+,a2-a4/d2-d3
	moveq	#0,d7
	rts

RefreshMCM:
	movem.l	a2-a4/a6/d3,-(sp)
	move.l	ScreenAddress,a0	;screen
	move.w	#$d800,d6
	move.l	d6,a1			;colour
	add.l	CharROMSwitch,a1
	move.l	CROMAddy,a2
	lea	TextTable,a4
	lea	MultiTextTable,a6
	
	move.w	ScrLUT,a5
	add.l	BPL2Address,a5		;bitplane
	moveq	#24,d3
.loop2
	moveq	#39,d7
.loop1
	moveq	#0,d5
	move.b	(a0)+,d5
	lea	(a2,d5.l*8),a3		;char data

	move.w	#7,d6

	move.b	(a1)+,d4
	and.w	#15,d4
	cmp.b	#8,d4
	blo.s	.mono
	and.w	#7,d4
.loop
	move.b	(a3)+,d5
	move.b	(MultiTextBack,d5.l),(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a6,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop
	lea	(-319.w,a5),a5
	dbra	d7,.loop1
	lea	(280.w,a5),a5
	dbra	d3,.loop2
	movem.l	(sp)+,a2-a4/a6/d3
	moveq	#0,d7
	rts

.mono
	move.b	(a3)+,d5
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a4,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.mono
	lea	(-319.w,a5),a5
	dbra	d7,.loop1
	lea	(280.w,a5),a5
	dbra	d3,.loop2
	movem.l	(sp)+,a2-a4/a6/d3
	moveq	#0,d7
	rts

RefreshBMM:
	movem.l	d3/a2,-(sp)
	move.l	BitPlaneTable,a0
	move.w	MCRLast,d6
	move.l	d6,a2
	moveq	#0,d4
	move.w	MCRCharLast,d4
	lsl.w	#3,d4
	move.w	#999,d7
	moveq	#0,d5
	lea	([CharAddress],d4.l),a1
.main
	move.b	(a2)+,d3
	move.w	#7,d6
	move.w	(BMLUT,d4.l*2),a5
	add.l	BPL2Address,a5
.loop
	move.w	(a1),d5
	move.b	d3,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	move.b	#-1,(24000.w,a5)
	lea	(40.w,a5),a5
	addq.l	#1,a1
	dbra	d6,.loop
	addq.w	#8,d4
	dbra	d7,.main
	movem.l	(sp)+,d3/a2
	moveq	#0,d7
	rts

RefreshMCBMM:
	movem.l	d1-d3/a2-a4/a6,-(sp)
	move.l	MultiTable,a0
	lea	MCMBackground,a6
	lea	MCMColour,a4
	move.w	#$d800,d6
	move.l	d6,a3
	add.l	CharROMSwitch,a3
	move.w	MCRLast,d6
	move.l	d6,a2
	moveq	#0,d4
	move.w	MCRCharLast,d4
	lsl.w	#3,d4
	move.w	#999,d7
	moveq	#0,d5
	lea	([CharAddress],d4.l),a1
.main
	move.b	(a2)+,d3
	move.b	(a3)+,d2
	and.w	#15,d2
	move.w	#7,d6
	move.w	(BMLUT,d4.l*2),a5
	add.l	BPL2Address,a5
.loop
	move.w	(a1),d5
	move.b	d3,d5
	move.l	(a0,d5.l*4),d1
	lsr.w	#8,d5
	move.b	(a6,d5.l),(24000.w,a5)
	lsl.w	#4,d5
	add.w	d2,d5
	and.l	(a4,d5.l*4),d1
	move.b	d1,(-8000.w,a5)
	lsr.l	#8,d1
	move.b	d1,(a5)
	lsr.l	#8,d1
	move.b	d1,(8000.w,a5)
	lsr.l	#8,d1
	move.b	d1,(16000.w,a5)
	lea	(40.w,a5),a5
	addq.w	#1,a1
	dbra	d6,.loop
	addq.w	#8,d4
	dbra	d7,.main
	movem.l	(sp)+,d1-d3/a2-a4/a6
	moveq	#0,d7
	rts

ReadJOY2:
	move.w	$dff00c,d5
	move.w	d5,d7
	and.w	#$300,d5
	and.w	#$3,d7
	lsr.w	#6,d5
	or.w	d7,d5
	lea	JoyTable,a5
	move.b	(a5,d5.w),d5
	move.b	(a0),d7
	and.w	#$e0,d7
	or.b	d5,d7
	move.b	$bfe001,d5
	and.b	#128,d5
	lsr.b	#3,d5
	or.b	d5,d7
	or.b	#$60,d7
	move.b	d7,(a0)
	move.b	d7,KeyWSt
	rts

WBKeyWrite:
	tst.b	BMM
	beq.s	KeyWrite
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	KeyWrite
.multi
	bsr	MultiBMM
KeyWrite:
	moveq	#0,d7
	move.b	(a0),d7
	move.w	d7,KeyBank
	move.b	KeyWSt,(a0)
	rts

DoubleY	macro
	tst.b	Sprite\2YY
	beq.s	.fin\1
	lea	Sprite\2+336,a1
	lea	Sprite\2+672,a5
	moveq	#20,d4
.loop\1
	move.l	(a1),(a5)
	move.l	(a1),-16(a5)
	move.l	4(a1),4(a5)
	move.l	4(a1),-12(a5)
	move.l	8(a1),8(a5)
	move.l	8(a1),-8(a5)
	move.l	12(a1),12(a5)
	move.l	12(a1),-4(a5)
	lea	(-16.w,a1),a1
	lea	(-32.w,a5),a5
	dbra	d4,.loop\1
.fin\1
	rts
	ENDM

MultiC	Macro
	move.l	a2,-(sp)
	lea	Data,a2
	sub.w	d6,d6
.multi
	move.b	(a1)+,d6
	move.b	(a2,d6*2),(a5)+
	move.b	1(a2,d6*2),7(a5)
	move.b	(a1)+,d6
	move.b	(a2,d6*2),(a5)+
	move.b	1(a2,d6*2),7(a5)
	move.b	(a1)+,d6
	move.b	(a2,d6*2),(a5)+
	move.b	1(a2,d6*2),7(a5)
	lea	(13.w,a5),a5
	dbra	d5,.multi
	move.l	(sp)+,a2
	ENDM

MonoEX	Macro
	moveq	#0,d4
	move.l	a2,-(sp)
	lea	Expand,a2
.loop4
	move.b	(a1)+,d4
	move.w	(a2,d4*2),(a5)+
	move.b	(a1)+,d4
	move.w	(a2,d4*2),(a5)+
	move.b	(a1)+,d4
	move.w	(a2,d4*2),(a5)+
	lea	(10.w,a5),a5
	dbra	d5,.loop4
	move.l	(sp)+,a2
	ENDM

MultiEX	Macro
	moveq	#0,d4
	movem.l	a2/a3,-(sp)
	lea	Data,a2
	lea	Expand,a3
	sub.w	d6,d6
.loop5
	move.b	(a1)+,d6
	move.b	(a2,d6*2),d4
	move.w	(a3,d4*2),(a5)+
	move.b	1(a2,d6*2),d4
	move.w	(a3,d4*2),6(a5)
	move.b	(a1)+,d6
	move.b	(a2,d6*2),d4
	move.w	(a3,d4*2),(a5)+
	move.b	1(a2,d6*2),d4
	move.w	(a3,d4*2),6(a5)
	move.b	(a1)+,d6
	move.b	(a2,d6*2),d4
	move.w	(a3,d4*2),(a5)+
	move.b	1(a2,d6*2),d4
	move.w	(a3,d4*2),6(a5)
	lea	(10.w,a5),a5
	dbra	d5,.loop5
	movem.l	(sp)+,a2/a3
	ENDM

Mono	Macro
.monolp
	move.w	(a1)+,(a5)+
	move.b	(a1)+,(a5)+
	clr.l	5(a5)
	lea	(13.w,a5),a5
	dbra	d5,.monolp
	ENDM

BMultiC	Macro
	lea	Data,a1
	move.b	(a0),d4
	move.b	(a1,d4.l*2),(a5,d5.l)
	move.b	1(a1,d4.l*2),8(a5,d5.l)
	ENDM

BMulEX	Macro
	lea	Data,a1
	move.b	(a0),d4
	move.b	(a1,d4.l*2),d7
	move.w	(Expand,d7.l*2),(a5,d5.l*2)
	move.b	1(a1,d4.l*2),d7
	move.w	(Expand,d7.l*2),8(a5,d5.l*2)
	ENDM

BMonoEX	Macro
	move.b	(a0),d4
	move.w	(Expand,d4.l*2),(a5,d5.l*2)
	ENDM

BYExp	Macro
	move.l	(a5),16(a5)
	move.l	4(a5),20(a5)
	move.l	8(a5),24(a5)
	move.l	12(a5),28(a5)
	ENDM

WBUpdateSprites:
	tst.b	BMM
	beq.s	UpdateSprites
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	UpdateSprites
.multi
	bsr	MultiBMM
UpdateSprites:
	moveq	#0,d7
	move.l	a2,-(sp)
	moveq	#0,d4
	moveq	#0,d5
	move.w	a0,d4
	sub.w	VICBank,d4
	move.w	d4,d5
	and.w	#63,d5
	lsr.w	#6,d4
	move.b	(SpritePC,d4.l),d6
	divu.w	#3,d5
	lsl.w	#4,d5
	move.w	d5,d4			;Rows Down in Sprite
	move.w	#0,d5
	swap	d5			;Columns across
	lea	Sprite0+16,a5
	lea	Sprite0MC,a2
	lea	(-736.w,a5),a5		;puts pointer @ proper row
	add.l	d4,a5			;in the sprite when 736 is added
	moveq	#0,d4
.loop
	tst.b	d6
	beq	.end
	lea	(736.w,a5),a5
	lsr.b	#1,d6
	bcc.s	.loop

	tst.b	(a2)+
	bne.s	.multi
	tst.b	23(a2)
	bne.s	.monoxex
	move.b	(a0),(a5,d5.l)
	tst.b	31(a2)
	beq.s	.loop
	BYExp
	bra.s	.loop
.multi
	tst.b	23(a2)
	bne.s	.multixex
	BMultiC
	tst.b	31(a2)
	beq.s	.loop
	BYExp
	bra.s	.loop
.monoxex
	BMonoEX
	tst.b	31(a2)
	beq	.loop
	BYExp
	bra	.loop
.multixex
	BMulEX
	tst.b	31(a2)
	beq	.loop
	BYExp
	bra	.loop

.end
	move.l	(sp)+,a2
	rts

WBSpriteEN:
	tst.b	BMM
	beq.s	SpriteEN
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	SpriteEN
.multi
	bsr	MultiBMM
SpriteEN:
	move.b	(a0),d6
	move.l	#Sprite0,d7
	move.l	#NullSprite,d4
	lea	CSprite,a1
	lea	Sprite0A,a5
	moveq	#7,d5
.loop
	lsr.b	#1,d6
	bcc.s	.over
	move.w	d7,6(a1)
	swap	d7
	move.w	d7,2(a1)
	swap	d7
	add.l	#736,d7
	addq.l	#8,a1
	st.b	(a5)+
	dbra	d5,.loop
	moveq	#0,d7
	moveq	#0,d4
	rts
.over
	move.w	d4,6(a1)
	swap	d4
	move.w	d4,2(a1)
	swap	d4
	add.l	#736,d7
	addq.l	#8,a1
	sf.b	(a5)+
	dbra	d5,.loop
	moveq	#0,d7
	moveq	#0,d4
	rts

WBSprite0X:
	tst.b	BMM
	beq.s	Sprite0X
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite0X
.multi
	bsr	MultiBMM
Sprite0X:
	bclr	#0,Sprite0+9
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite0MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,Sprite0+9
.over1
	move.b	d5,Sprite0+1
	rts

WBSprite0Y:
	tst.b	BMM
	beq.s	Sprite0Y
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite0Y
.multi
	bsr	MultiBMM
Sprite0Y:
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	addq.b	#2,d5
	move.b	d5,Sprite0
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,Sprite0+8
	rts

WBSprite0P:
	tst.b	BMM
	beq.s	Sprite0P
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite0P
.multi
	bsr	MultiBMM
Sprite0P:
	sub.w	d6,d6
	moveq	#0,d5
	moveq	#0,d7
	move.l	d6,a1
	move.l	#SpritePC,a5
	move.b	(a0),d5
	move.b	Sprite0PT,d7
	bclr	#0,(a5,d7.l)
	bset	#0,(a5,d5.l)
	move.b	(a5,d5.l),d4
	move.b	d5,Sprite0PT
	lsl.w	#6,d5
	add.w	VICBank,d5
	add.l	d5,d5
	move.l	d5,a1
	add.l	a6,a1		;New Sprite Area

	move.l	d7,d5
	lsl.w	#6,d5
	add.w	OldVICBank,d5
	add.l	d5,d5
	move.l	d5,a5
	add.l	a6,a5		;Old Sprite Area

	cmp.l	a1,a5
	beq.s	.main
	and.b	#%11111110,d4
	bne.s	.clear
	move.w	#$100,d4
	tst.b	(SpritePC,d7.l)
	beq.s	.NotUsed
	moveq	#62,d7
.copylp1
	add.w	d4,(a1)+
	dbra	d7,.copylp1
	bra.s	.main
.clear
	tst.b	(SpritePC,d7.l)
	bne.s	.main
	move.w	#$100,d4
	moveq	#62,d7
.clearlp
	sub.w	d4,(a5)+
	dbra	d7,.clearlp
	bra.s	.main
.NotUsed
	moveq	#62,d7
.copylp
	sub.w	d4,(a5)+
	add.w	d4,(a1)+
	dbra	d7,.copylp
.main
	move.b	(a0),d6
	lsl.w	#6,d6
	add.w	VICBank,d6
	move.l	d6,a1
	moveq	#0,d4
	moveq	#0,d7
	lea	Sprite0+16,a5
	moveq	#20,d5
	tst.b	Sprite0MC
	beq	.mono
	tst.b	Sprite0XX
	bne	.multix
	MultiC
	DoubleY	0,0
.mono
	tst.b	Sprite0XX
	bne	.monox
	Mono
	DoubleY	1,0
.monox
	MonoEX
	DoubleY	2,0
.multix
	MultiEX
	DoubleY	3,0

WBSprite1X:
	tst.b	BMM
	beq.s	Sprite1X
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite1X
.multi
	bsr	MultiBMM
Sprite1X:
	bclr	#0,Sprite1+9
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite1MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,Sprite1+9
.over1
	move.b	d5,Sprite1+1
	rts

WBSprite1Y:
	tst.b	BMM
	beq.s	Sprite1Y
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite1Y
.multi
	bsr	MultiBMM
Sprite1Y:
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	addq.b	#2,d5
	move.b	d5,Sprite1
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,Sprite1+8
	rts

WBSprite1P:
	tst.b	BMM
	beq.s	Sprite1P
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite1P
.multi
	bsr	MultiBMM
Sprite1P:
	sub.w	d6,d6
	moveq	#0,d5
	moveq	#0,d7
	move.l	d6,a1
	move.l	#SpritePC,a5
	move.b	(a0),d5
	move.b	Sprite1PT,d7
	bclr	#1,(a5,d7.l)
	bset	#1,(a5,d5.l)
	move.b	(a5,d5.l),d4
	move.b	d5,Sprite1PT
	lsl.w	#6,d5
	add.w	VICBank,d5
	add.l	d5,d5
	move.l	d5,a1
	add.l	a6,a1		;New Sprite Area

	move.l	d7,d5
	lsl.w	#6,d5
	add.w	OldVICBank,d5
	add.l	d5,d5
	move.l	d5,a5
	add.l	a6,a5		;Old Sprite Area

	cmp.l	a1,a5
	beq.s	.main
	and.b	#%11111101,d4
	bne.s	.clear
	move.w	#$100,d4
	tst.b	(SpritePC,d7.l)
	beq.s	.NotUsed
	moveq	#62,d7
.copylp1
	add.w	d4,(a1)+
	dbra	d7,.copylp1
	bra.s	.main
.clear
	tst.b	(SpritePC,d7.l)
	bne.s	.main
	move.w	#$100,d4
	moveq	#62,d7
.clearlp
	sub.w	d4,(a5)+
	dbra	d7,.clearlp
	bra.s	.main
.NotUsed
	moveq	#62,d7
.copylp
	sub.w	d4,(a5)+
	add.w	d4,(a1)+
	dbra	d7,.copylp
.main
	move.b	(a0),d6
	lsl.w	#6,d6
	add.w	VICBank,d6
	move.l	d6,a1
	moveq	#0,d4
	moveq	#0,d7
	lea	Sprite1+16,a5
	moveq	#20,d5
	tst.b	Sprite1MC
	beq	.mono
	tst.b	Sprite1XX
	bne	.multix
	MultiC
	DoubleY	0,1
.mono
	tst.b	Sprite1XX
	bne	.monox
	Mono
	DoubleY	1,1
.monox
	MonoEX
	DoubleY	2,1
.multix
	MultiEX
	DoubleY	3,1

WBSprite2X:
	tst.b	BMM
	beq.s	Sprite2X
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite2X
.multi
	bsr	MultiBMM
Sprite2X:
	bclr	#0,Sprite2+9
	moveq	#0,d5
	moveq	#0,d7
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite2MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,Sprite2+9
.over1
	move.b	d5,Sprite2+1
	rts

WBSprite2Y:
	tst.b	BMM
	beq.s	Sprite2Y
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite2Y
.multi
	bsr	MultiBMM
Sprite2Y:
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	addq.b	#2,d5
	move.b	d5,Sprite2
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,Sprite2+8
	rts

WBSprite2P:
	tst.b	BMM
	beq.s	Sprite2P
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite2P
.multi
	bsr	MultiBMM
Sprite2P:
	sub.w	d6,d6
	moveq	#0,d7
	moveq	#0,d5
	move.l	d6,a1
	move.l	#SpritePC,a5
	move.b	(a0),d5
	move.b	Sprite2PT,d7
	bclr	#2,(a5,d7.l)
	bset	#2,(a5,d5.l)
	move.b	(a5,d5.l),d4
	move.b	d5,Sprite2PT
	lsl.w	#6,d5
	add.w	VICBank,d5
	add.l	d5,d5
	move.l	d5,a1
	add.l	a6,a1		;New Sprite Area

	move.l	d7,d5
	lsl.w	#6,d5
	add.w	OldVICBank,d5
	add.l	d5,d5
	move.l	d5,a5
	add.l	a6,a5		;Old Sprite Area

	cmp.l	a1,a5
	beq.s	.main
	and.b	#%11111011,d4
	bne.s	.clear
	move.w	#$100,d4
	tst.b	(SpritePC,d7.l)
	beq.s	.NotUsed
	moveq	#62,d7
.copylp1
	add.w	d4,(a1)+
	dbra	d7,.copylp1
	bra.s	.main
.clear
	tst.b	(SpritePC,d7.l)
	bne.s	.main
	move.w	#$100,d4
	moveq	#62,d7
.clearlp
	sub.w	d4,(a5)+
	dbra	d7,.clearlp
	bra.s	.main
.NotUsed
	moveq	#62,d7
.copylp
	sub.w	d4,(a5)+
	add.w	d4,(a1)+
	dbra	d7,.copylp
.main
	move.b	(a0),d6
	lsl.w	#6,d6
	add.w	VICBank,d6
	move.l	d6,a1
	moveq	#0,d4
	moveq	#0,d7
	lea	Sprite2+16,a5
	moveq	#20,d5
	tst.b	Sprite2MC
	beq	.mono
	tst.b	Sprite2XX
	bne	.multix
	MultiC
	DoubleY	0,2
.mono
	tst.b	Sprite2XX
	bne	.monox
	Mono
	DoubleY	1,2
.monox
	MonoEX
	DoubleY	2,2
.multix
	MultiEX
	DoubleY	3,2

WBSprite3X:
	tst.b	BMM
	beq.s	Sprite3X
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite3X
.multi
	bsr	MultiBMM
Sprite3X:
	bclr	#0,Sprite3+9
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite3MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,Sprite3+9
.over1
	move.b	d5,Sprite3+1
	rts

WBSprite3Y:
	tst.b	BMM
	beq.s	Sprite3Y
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite3Y
.multi
	bsr	MultiBMM
Sprite3Y:
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	addq.b	#2,d5
	move.b	d5,Sprite3
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,Sprite3+8
	rts

WBSprite3P:
	tst.b	BMM
	beq.s	Sprite3P
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite3P
.multi
	bsr	MultiBMM
Sprite3P:
	sub.w	d6,d6
	moveq	#0,d7
	moveq	#0,d5
	move.l	d6,a1
	move.l	#SpritePC,a5
	move.b	(a0),d5
	move.b	Sprite3PT,d7
	bclr	#3,(a5,d7.l)
	bset	#3,(a5,d5.l)
	move.b	(a5,d5.l),d4
	move.b	d5,Sprite3PT
	lsl.w	#6,d5
	add.w	VICBank,d5
	add.l	d5,d5
	move.l	d5,a1
	add.l	a6,a1		;New Sprite Area

	move.l	d7,d5
	lsl.w	#6,d5
	add.w	OldVICBank,d5
	add.l	d5,d5
	move.l	d5,a5
	add.l	a6,a5		;Old Sprite Area

	cmp.l	a1,a5
	beq.s	.main
	and.b	#%11110111,d4
	bne.s	.clear
	move.w	#$100,d4
	tst.b	(SpritePC,d7.l)
	beq.s	.NotUsed
	moveq	#62,d7
.copylp1
	add.w	d4,(a1)+
	dbra	d7,.copylp1
	bra.s	.main
.clear
	tst.b	(SpritePC,d7.l)
	bne.s	.main
	move.w	#$100,d4
	moveq	#62,d7
.clearlp
	sub.w	d4,(a5)+
	dbra	d7,.clearlp
	bra.s	.main
.NotUsed
	moveq	#62,d7
.copylp
	sub.w	d4,(a5)+
	add.w	d4,(a1)+
	dbra	d7,.copylp
.main
	move.b	(a0),d6
	lsl.w	#6,d6
	add.w	VICBank,d6
	move.l	d6,a1
	moveq	#0,d4
	moveq	#0,d7
	lea	Sprite3+16,a5
	moveq	#20,d5
	tst.b	Sprite3MC
	beq	.mono
	tst.b	Sprite3XX
	bne	.multix
	MultiC
	DoubleY	0,3
.mono
	tst.b	Sprite3XX
	bne	.monox
	Mono
	DoubleY	1,3
.monox
	MonoEX
	DoubleY	2,3
.multix
	MultiEX
	DoubleY	3,3

WBSprite4X:
	tst.b	BMM
	beq.s	Sprite4X
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite4X
.multi
	bsr	MultiBMM
Sprite4X:
	bclr	#0,Sprite4+9
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite4MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,Sprite4+9
.over1
	move.b	d5,Sprite4+1
	rts

WBSprite4Y:
	tst.b	BMM
	beq.s	Sprite4Y
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite4Y
.multi
	bsr	MultiBMM
Sprite4Y:
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	addq.b	#2,d5
	move.b	d5,Sprite4
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,Sprite4+8
	rts

WBSprite4P:
	tst.b	BMM
	beq.s	Sprite4P
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite4P
.multi
	bsr	MultiBMM
Sprite4P:
	sub.w	d6,d6
	moveq	#0,d7
	moveq	#0,d5
	move.l	d6,a1
	move.l	#SpritePC,a5
	move.b	(a0),d5
	move.b	Sprite4PT,d7
	bclr	#4,(a5,d7.l)
	bset	#4,(a5,d5.l)
	move.b	(a5,d5.l),d4
	move.b	d5,Sprite4PT
	lsl.w	#6,d5
	add.w	VICBank,d5
	add.l	d5,d5
	move.l	d5,a1
	add.l	a6,a1		;New Sprite Area

	move.l	d7,d5
	lsl.w	#6,d5
	add.w	OldVICBank,d5
	add.l	d5,d5
	move.l	d5,a5
	add.l	a6,a5		;Old Sprite Area

	cmp.l	a1,a5
	beq.s	.main
	and.b	#%11101111,d4
	bne.s	.clear
	move.w	#$100,d4
	tst.b	(SpritePC,d7.l)
	beq.s	.NotUsed
	moveq	#62,d7
.copylp1
	add.w	d4,(a1)+
	dbra	d7,.copylp1
	bra.s	.main
.clear
	tst.b	(SpritePC,d7.l)
	bne.s	.main
	move.w	#$100,d4
	moveq	#62,d7
.clearlp
	sub.w	d4,(a5)+
	dbra	d7,.clearlp
	bra.s	.main
.NotUsed
	moveq	#62,d7
.copylp
	sub.w	d4,(a5)+
	add.w	d4,(a1)+
	dbra	d7,.copylp
.main
	move.b	(a0),d6
	lsl.w	#6,d6
	add.w	VICBank,d6
	move.l	d6,a1
	moveq	#0,d4
	moveq	#0,d7
	lea	Sprite4+16,a5
	moveq	#20,d5
	tst.b	Sprite4MC
	beq	.mono
	tst.b	Sprite4XX
	bne	.multix
	MultiC
	DoubleY	0,4
.mono
	tst.b	Sprite4XX
	bne	.monox
	Mono
	DoubleY	1,4
.monox
	MonoEX
	DoubleY	2,4
.multix
	MultiEX
	DoubleY	3,4

WBSprite5X:
	tst.b	BMM
	beq.s	Sprite5X
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite5X
.multi
	bsr	MultiBMM
Sprite5X:
	bclr	#0,Sprite5+9
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite5MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,Sprite5+9
.over1
	move.b	d5,Sprite5+1
	rts

WBSprite5Y:
	tst.b	BMM
	beq.s	Sprite5Y
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite5Y
.multi
	bsr	MultiBMM
Sprite5Y:
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	addq.b	#2,d5
	move.b	d5,Sprite5
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,Sprite5+8
	rts

WBSprite5P:
	tst.b	BMM
	beq.s	Sprite5P
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite5P
.multi
	bsr	MultiBMM
Sprite5P:
	sub.w	d6,d6
	moveq	#0,d7
	moveq	#0,d5
	move.l	d6,a1
	move.l	#SpritePC,a5
	move.b	(a0),d5
	move.b	Sprite5PT,d7
	bclr	#5,(a5,d7.l)
	bset	#5,(a5,d5.l)
	move.b	(a5,d5.l),d4
	move.b	d5,Sprite5PT
	lsl.w	#6,d5
	add.w	VICBank,d5
	add.l	d5,d5
	move.l	d5,a1
	add.l	a6,a1		;New Sprite Area

	move.l	d7,d5
	lsl.w	#6,d5
	add.w	OldVICBank,d5
	add.l	d5,d5
	move.l	d5,a5
	add.l	a6,a5		;Old Sprite Area

	cmp.l	a1,a5
	beq.s	.main
	and.b	#%11011111,d4
	bne.s	.clear
	move.w	#$100,d4
	tst.b	(SpritePC,d7.l)
	beq.s	.NotUsed
	moveq	#62,d7
.copylp1
	add.w	d4,(a1)+
	dbra	d7,.copylp1
	bra.s	.main
.clear
	tst.b	(SpritePC,d7.l)
	bne.s	.main
	move.w	#$100,d4
	moveq	#62,d7
.clearlp
	sub.w	d4,(a5)+
	dbra	d7,.clearlp
	bra.s	.main
.NotUsed
	moveq	#62,d7
.copylp
	sub.w	d4,(a5)+
	add.w	d4,(a1)+
	dbra	d7,.copylp
.main
	move.b	(a0),d6
	lsl.w	#6,d6
	add.w	VICBank,d6
	move.l	d6,a1
	moveq	#0,d4
	moveq	#0,d7
	lea	Sprite5+16,a5
	moveq	#20,d5
	tst.b	Sprite5MC
	beq	.mono
	tst.b	Sprite5XX
	bne	.multix
	MultiC
	DoubleY	0,5
.mono
	tst.b	Sprite5XX
	bne	.monox
	Mono
	DoubleY	1,5
.monox
	MonoEX
	DoubleY	2,5
.multix
	MultiEX
	DoubleY	3,5

WBSprite6X:
	tst.b	BMM
	beq.s	Sprite6X
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite6X
.multi
	bsr	MultiBMM
Sprite6X:
	bclr	#0,Sprite6+9
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite6MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,Sprite6+9
.over1
	move.b	d5,Sprite6+1
	rts

WBSprite6Y:
	tst.b	BMM
	beq.s	Sprite6Y
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite6Y
.multi
	bsr	MultiBMM
Sprite6Y:
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	addq.b	#2,d5
	move.b	d5,Sprite6
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,Sprite6+8
	rts

WBSprite6P:
	tst.b	BMM
	beq.s	Sprite6P
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite6P
.multi
	bsr	MultiBMM
Sprite6P:
	sub.w	d6,d6
	moveq	#0,d7
	moveq	#0,d5
	move.l	d6,a1
	move.l	#SpritePC,a5
	move.b	(a0),d5
	move.b	Sprite6PT,d7
	bclr	#6,(a5,d7.l)
	bset	#6,(a5,d5.l)
	move.b	(a5,d5.l),d4
	move.b	d5,Sprite6PT
	lsl.w	#6,d5
	add.w	VICBank,d5
	add.l	d5,d5
	move.l	d5,a1
	add.l	a6,a1		;New Sprite Area

	move.l	d7,d5
	lsl.w	#6,d5
	add.w	OldVICBank,d5
	add.l	d5,d5
	move.l	d5,a5
	add.l	a6,a5		;Old Sprite Area

	cmp.l	a1,a5
	beq.s	.main
	and.b	#%10111111,d4
	bne.s	.clear
	move.w	#$100,d4
	tst.b	(SpritePC,d7.l)
	beq.s	.NotUsed
	moveq	#62,d7
.copylp1
	add.w	d4,(a1)+
	dbra	d7,.copylp1
	bra.s	.main
.clear
	tst.b	(SpritePC,d7.l)
	bne.s	.main
	move.w	#$100,d4
	moveq	#62,d7
.clearlp
	sub.w	d4,(a5)+
	dbra	d7,.clearlp
	bra.s	.main
.NotUsed
	moveq	#62,d7
.copylp
	sub.w	d4,(a5)+
	add.w	d4,(a1)+
	dbra	d7,.copylp
.main
	move.b	(a0),d6
	lsl.w	#6,d6
	add.w	VICBank,d6
	move.l	d6,a1
	moveq	#0,d4
	moveq	#0,d7
	lea	Sprite6+16,a5
	moveq	#20,d5
	tst.b	Sprite6MC
	beq	.mono
	tst.b	Sprite6XX
	bne	.multix
	MultiC
	DoubleY	0,6
.mono
	tst.b	Sprite6XX
	bne	.monox
	Mono
	DoubleY	1,6
.monox
	MonoEX
	DoubleY	2,6
.multix
	MultiEX
	DoubleY	3,6

WBSprite7X:
	tst.b	BMM
	beq.s	Sprite7X
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite7X
.multi
	bsr	MultiBMM
Sprite7X:
	bclr	#0,Sprite7+9
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite7MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,Sprite7+9
.over1
	move.b	d5,Sprite7+1
	rts

WBSprite7Y:
	tst.b	BMM
	beq.s	Sprite7Y
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite7Y
.multi
	bsr	MultiBMM
Sprite7Y:
	moveq	#0,d7
	moveq	#0,d5
	move.b	(a0),d5
	addq.b	#2,d5
	move.b	d5,Sprite7
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,Sprite7+8
	rts

WBSprite7P:
	tst.b	BMM
	beq.s	Sprite7P
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite7P
.multi
	bsr	MultiBMM
Sprite7P:
	sub.w	d6,d6
	moveq	#0,d7
	moveq	#0,d5
	move.l	d6,a1
	move.l	#SpritePC,a5
	move.b	(a0),d5
	move.b	Sprite7PT,d7
	bclr	#7,(a5,d7.l)
	bset	#7,(a5,d5.l)
	move.b	(a5,d5.l),d4
	move.b	d5,Sprite7PT
	lsl.w	#6,d5
	add.w	VICBank,d5
	add.l	d5,d5
	move.l	d5,a1
	add.l	a6,a1		;New Sprite Area

	move.l	d7,d5
	lsl.w	#6,d5
	add.w	OldVICBank,d5
	add.l	d5,d5
	move.l	d5,a5
	add.l	a6,a5		;Old Sprite Area

	cmp.l	a1,a5
	beq.s	.main
	and.b	#%01111111,d4
	bne.s	.clear
	move.w	#$100,d4
	tst.b	(SpritePC,d7.l)
	beq.s	.NotUsed
	moveq	#62,d7
.copylp1
	add.w	d4,(a1)+
	dbra	d7,.copylp1
	bra.s	.main
.clear
	tst.b	(SpritePC,d7.l)
	bne.s	.main
	move.w	#$100,d4
	moveq	#62,d7
.clearlp
	sub.w	d4,(a5)+
	dbra	d7,.clearlp
	bra.s	.main
.NotUsed
	moveq	#62,d7
.copylp
	sub.w	d4,(a5)+
	add.w	d4,(a1)+
	dbra	d7,.copylp
.main
	move.b	(a0),d6
	lsl.w	#6,d6
	add.w	VICBank,d6
	move.l	d6,a1
	moveq	#0,d4
	moveq	#0,d7
	lea	Sprite7+16,a5
	moveq	#20,d5
	tst.b	Sprite7MC
	beq	.mono
	tst.b	Sprite7XX
	bne	.multix
	MultiC
	DoubleY	0,7
.mono
	tst.b	Sprite7XX
	bne	.monox
	Mono
	DoubleY	1,7
.monox
	MonoEX
	DoubleY	2,7
.multix
	MultiEX
	DoubleY	3,7

WBSprite0C:
	tst.b	BMM
	beq.s	Sprite0C
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite0C
.multi
	bsr	MultiBMM
Sprite0C:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),SColour0+2
	rts

WBSprite1C:
	tst.b	BMM
	beq.s	Sprite1C
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite1C
.multi
	bsr	MultiBMM
Sprite1C:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),SColour1+2
	rts

WBSprite2C:
	tst.b	BMM
	beq.s	Sprite2C
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite2C
.multi
	bsr	MultiBMM
Sprite2C:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),SColour0+6
	rts

WBSprite3C:
	tst.b	BMM
	beq.s	Sprite3C
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite3C
.multi
	bsr	MultiBMM
Sprite3C:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),SColour1+6
	rts

WBSprite4C:
	tst.b	BMM
	beq.s	Sprite4C
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite4C
.multi
	bsr	MultiBMM
Sprite4C:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),SColour0+10
	rts

WBSprite5C:
	tst.b	BMM
	beq.s	Sprite5C
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite5C
.multi
	bsr	MultiBMM
Sprite5C:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),SColour1+10
	rts

WBSprite6C:
	tst.b	BMM
	beq.s	Sprite6C
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite6C
.multi
	bsr	MultiBMM
Sprite6C:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),SColour0+14
	rts

WBSprite7C:
	tst.b	BMM
	beq.s	Sprite7C
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	Sprite7C
.multi
	bsr	MultiBMM
Sprite7C:
	move.b	(a0),d7
	and.w	#15,d7
	move.w	(Palette,d7.l*2),SColour1+14
	rts

WBSpriteMSBX:
	tst.b	BMM
	beq.s	SpriteMSBX
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	SpriteMSBX
.multi
	bsr	MultiBMM
SpriteMSBX:
	moveq	#0,d7
	move.b	(a0),d7
	moveq	#7,d5
	lea	Sprite0+1,a1
	lea	Sprite0MSB,a5
.loop
	lsr.b	#1,d7
	bcc.s	.over
	tst.w	(a5)
	bne.s	.nochange
	move.w	#256,(a5)
	add.b	#128,(a1)
.nochange
	addq.l	#2,a5
	lea	(736.w,a1),a1
	dbra	d5,.loop
	rts
.over
	tst.w	(a5)
	beq.s	.nochange1
	move.w	#0,(a5)
	sub.b	#128,(a1)
.nochange1
	addq.l	#2,a5
	lea	(736.w,a1),a1
	dbra	d5,.loop
	rts

WBSpriteMCM:
	tst.b	BMM
	beq.s	SpriteMCM
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	SpriteMCM
.multi
	bsr	MultiBMM
SpriteMCM:
	moveq	#0,d7
	sub.w	d6,d6
	movem.l	a2-a4,-(sp)
	lea	Sprite0PT,a2
	lea	Sprite0+16,a5
	lea	Data,a3
	lea	Expand,a4
	move.b	(a0),d7
	moveq	#7,d5
.main	
	move.b	(a2)+,d6
	lsl.w	#6,d6
	add.w	VICBank,d6
	move.l	d6,a1
	moveq	#20,d4
	lsr.b	#1,d7
	bcc	.mono
	st.b	-17(a2)
	tst.b	7(a2)			;SpritexXX
	bne.s	.multix
	tst.b	15(a2)
	bne	.multiy
	sub.w	d6,d6
.loop
	move.b	(a1)+,d6
	move.b	(a3,d6*2),(a5)+
	move.b	1(a3,d6*2),7(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),(a5)+
	move.b	1(a3,d6*2),7(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),(a5)+
	move.b	1(a3,d6*2),7(a5)
	lea	(13.w,a5),a5
	dbra	d4,.loop
	lea	(400.w,a5),a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	rts

.multix
	move.l	d0,-(sp)
	sub.w	d6,d6
	tst.b	15(a2)
	bne	.multixy
.loop1
	move.b	(a1)+,d6
	move.b	(a3,d6*2),d0
	move.w	(a4,d0*2),(a5)+
	move.b	1(a3,d6*2),d0
	move.w	(a4,d0*2),6(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),d0
	move.w	(a4,d0*2),(a5)+
	move.b	1(a3,d6*2),d0
	move.w	(a4,d0*2),6(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),d0
	move.w	(a4,d0*2),(a5)+
	move.b	1(a3,d6*2),d0
	move.w	(a4,d0*2),6(a5)
	lea	(10.w,a5),a5
	dbra	d4,.loop1
	move.l	(sp)+,d0
	lea	(400.w,a5),a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	rts

.mono
	sf.b	-17(a2)
	tst.b	7(a2)
	bne.s	.monox
	tst.b	15(a2)
	bne	.monoy
.loop2
	move.w	(a1)+,(a5)+
	move.b	(a1)+,(a5)+
	clr.l	5(a5)
	lea	(13.w,a5),a5
	dbra	d4,.loop2
	lea	(400.w,a5),a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	rts

.monox
	sub.w	d6,d6
	tst.b	15(a2)
	bne.s	.monoxy
.loop4
	move.b	(a1)+,d6
	move.w	(a4,d6*2),(a5)+
	move.b	(a1)+,d6
	move.w	(a4,d6*2),(a5)+
	move.b	(a1)+,d6
	move.w	(a4,d6*2),(a5)+
	clr.l	2(a5)
	clr.l	6(a5)
	lea	(10.w,a5),a5
	dbra	d4,.loop4
	lea	(400.w,a5),a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	rts

.monoxy
	move.b	(a1)+,d6
	move.w	(a4,d6*2),(a5)+
	move.w	(a4,d6*2),14(a5)
	move.b	(a1)+,d6
	move.w	(a4,d6*2),(a5)+
	move.w	(a4,d6*2),14(a5)
	move.b	(a1)+,d6
	move.w	(a4,d6*2),(a5)+
	move.w	(a4,d6*2),14(a5)
	clr.l	2(a5)
	clr.l	6(a5)
	clr.l	18(a5)
	clr.l	22(a5)
	lea	(26.w,a5),a5
	dbra	d4,.monoxy
	lea	(64.w,a5),a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	rts

.monoy
	move.w	(a1),(a5)+
	move.w	(a1)+,14(a5)
	move.b	(a1),(a5)+
	move.b	(a1)+,15(a5)
	clr.l	5(a5)
	clr.l	21(a5)
	lea	(29.w,a5),a5
	dbra	d4,.monoy
	lea	(64.w,a5),a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	rts

.multixy
	move.b	(a1)+,d6
	move.b	(a3,d6*2),d0
	move.w	(a4,d0*2),(a5)+
	move.w	(a4,d0*2),14(a5)
	move.b	1(a3,d6*2),d0
	move.w	(a4,d0*2),6(a5)
	move.w	(a4,d0*2),22(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),d0
	move.w	(a4,d0*2),(a5)+
	move.w	(a4,d0*2),14(a5)
	move.b	1(a3,d6*2),d0
	move.w	(a4,d0*2),6(a5)
	move.w	(a4,d0*2),22(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),d0
	move.w	(a4,d0*2),(a5)+
	move.w	(a4,d0*2),14(a5)
	move.b	1(a3,d6*2),d0
	move.w	(a4,d0*2),6(a5)
	move.w	(a4,d0*2),22(a5)
	lea	(26.w,a5),a5
	dbra	d4,.multixy
	move.l	(sp)+,d0
	lea	(64.w,a5),a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	rts

.multiy
	sub.w	d6,d6
.loop3
	move.b	(a1)+,d6
	move.b	(a3,d6*2),(a5)+
	move.b	(a3,d6*2),15(a5)
	move.b	1(a3,d6*2),7(a5)
	move.b	1(a3,d6*2),23(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),(a5)+
	move.b	(a3,d6*2),15(a5)
	move.b	1(a3,d6*2),7(a5)
	move.b	1(a3,d6*2),23(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),(a5)+
	move.b	(a3,d6*2),15(a5)
	move.b	1(a3,d6*2),7(a5)
	move.b	1(a3,d6*2),23(a5)
	lea	(29.w,a5),a5
	dbra	d4,.loop3
	lea	(64.w,a5),a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	rts

WBSpriteMC0:
	tst.b	BMM
	beq.s	SpriteMC0
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	SpriteMC0
.multi
	bsr	MultiBMM
SpriteMC0:
	move.b	(a0),d7
	and.w	#15,d7
	lea	Palette,a1
	move.w	(a1,d7.l*2),d5
	lea	MColour0,a1
	lea	MColour1,a5
	move.w	d5,2(a1)
	move.w	d5,10(a1)
	move.w	d5,18(a1)
	move.w	d5,26(a1)
	move.w	d5,2(a5)
	move.w	d5,10(a5)
	move.w	d5,18(a5)
	move.w	d5,26(a5)
	rts

WBSpriteMC1:
	tst.b	BMM
	beq.s	SpriteMC1
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	SpriteMC1
.multi
	bsr	MultiBMM
SpriteMC1:
	move.b	(a0),d7
	and.w	#15,d7
	lea	Palette,a1
	move.w	(a1,d7.l*2),d5
	lea	MColour0,a1
	lea	MColour1,a5
	move.w	d5,6(a1)
	move.w	d5,14(a1)
	move.w	d5,22(a1)
	move.w	d5,30(a1)
	move.w	d5,6(a5)
	move.w	d5,14(a5)
	move.w	d5,22(a5)
	move.w	d5,30(a5)
	rts

WBSpriteXX:
	tst.b	BMM
	beq.s	SpriteXX
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	SpriteXX
.multi
	bsr	MultiBMM
SpriteXX:
	moveq	#0,d7
	move.b	(a0),d7
	movem.l	d0/a2,-(sp)
	lea	Sprite0XX,a2
	lea	Sprite0+16,a1
	moveq	#7,d5
.main
	lsr.b	#1,d7
	bcc.s	.shrink
	tst.b	(a2)+
	bne.s	.leave
	st.b	-1(a2)
	lea	Expand,a5
	moveq	#41,d4
	sub.w	d6,d6
.loop
	move.l	(a1),d0			;data
	rol.l	#8,d0
	move.b	d0,d6
	move.w	(a5,d6*2),(a1)+
	rol.l	#8,d0
	move.b	d0,d6
	move.w	(a5,d6*2),(a1)+
	rol.l	#8,d0
	move.b	d0,d6
	move.w	(a5,d6*2),(a1)+
	addq.l	#2,a1
	move.l	(a1),d0			;colour
	rol.l	#8,d0
	move.b	d0,d6
	move.w	(a5,d6*2),(a1)+
	rol.l	#8,d0
	move.b	d0,d6
	move.w	(a5,d6*2),(a1)+
	rol.l	#8,d0
	move.b	d0,d6
	move.w	(a5,d6*2),(a1)+
	addq.l	#2,a1
	dbra	d4,.loop
	lea	(64.w,a1),a1
	dbra	d5,.main
	movem.l	(sp)+,d0/a2
	rts
.leave
	lea	(736.w,a1),a1
	dbra	d5,.main
	movem.l	(sp)+,d0/a2
	rts

.shrink
	tst.b	(a2)+
	beq.s	.leave
	sf.b	-1(a2)
	sub.w	d6,d6
	move.b	-9(a2),d6		;SpritexPT
	lsl.w	#6,d6
	add.w	VICBank,d6
	move.l	d6,a5
	moveq	#20,d4
	tst.b	-25(a2)			;SpritexMC
	bne.s	.multi
	tst.b	7(a2)
	bne.s	.vert
.loop2	
	move.w	(a5)+,(a1)+
	move.b	(a5)+,(a1)+
	clr.b	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	dbra	d4,.loop2
	lea	(400.w,a1),a1
	dbra	d5,.main
	movem.l	(sp)+,d0/a2
	rts
.vert
	move.w	(a5),(a1)+
	move.b	2(a5),(a1)+
	clr.b	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	move.w	(a5)+,(a1)+
	move.b	(a5)+,(a1)+
	clr.b	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	dbra	d4,.vert
	lea	(64.w,a1),a1
	dbra	d5,.main
	movem.l	(sp)+,d0/a2
	rts
.multi
	move.l	a3,-(sp)
	lea	Data,a3
	sub.w	d6,d6
	tst.b	7(a2)
	bne.s	.multiv
.loop3
	move.b	(a5)+,d6
	move.b	(a3,d6*2),(a1)+
	move.b	1(a3,d6*2),7(a1)
	move.b	(a5)+,d6
	move.b	(a3,d6*2),(a1)+
	move.b	1(a3,d6*2),7(a1)
	move.b	(a5)+,d6
	move.b	(a3,d6*2),(a1)+
	move.b	(a3,d6*2),7(a1)
	clr.b	(a1)+
	clr.l	(a1)+
	clr.b	3(a1)
	clr.l	4(a1)
	addq.l	#8,a1
	dbra	d4,.loop3
	move.l	(sp)+,a3
	lea	(400.w,a1),a1
	dbra	d5,.main
	movem.l	(sp)+,d0/a2
	rts

.multiv
	move.b	(a5)+,d6
	move.b	(a3,d6*2),(a1)+
	move.b	1(a3,d6*2),7(a1)
	move.b	(a3,d6*2),15(a1)
	move.b	1(a3,d6*2),23(a1)
	move.b	(a5)+,d6
	move.b	(a3,d6*2),(a1)+
	move.b	1(a3,d6*2),7(a1)
	move.b	(a3,d6*2),15(a1)
	move.b	1(a3,d6*2),23(a1)
	move.b	(a5)+,d6
	move.b	(a3,d6*2),(a1)+
	move.b	1(a3,d6*2),7(a1)
	move.b	(a3,d6*2),15(a1)
	move.b	1(a3,d6*2),23(a1)
	clr.b	(a1)+
	clr.b	15(a1)
	clr.l	(a1)+
	clr.l	12(a1)
	clr.b	3(a1)
	clr.l	4(a1)
	clr.b	19(a1)
	clr.l	20(a1)
	lea	(24.w,a1),a1
	dbra	d4,.multiv
	move.l	(sp)+,a3
	lea	(64.w,a1),a1
	dbra	d5,.main
	movem.l	(sp)+,d0/a2
	rts

WBSpriteYY:
	tst.b	BMM
	beq.s	SpriteYY
	tst.b	MCM
	bne.s	.multi
	bsr	MonoBMM
	bra.s	SpriteYY
.multi
	bsr	MultiBMM
SpriteYY:
	moveq	#0,d7
	move.b	(a0),d7
	move.l	a2,-(sp)
	lea	Sprite0+336,a1		;Halfway down the sprite?
	lea	Sprite0+672,a5		;Last Row of Sprite data?
	lea	Sprite0YY,a2
	moveq	#7,d5
.main
	lsr.b	#1,d7
	bcc.s	.shrink
	tst.b	(a2)+
	bne	.leave
	st.b	-1(a2)
	moveq	#20,d4
.expand
	move.l	(a1),(a5)
	move.l	(a1),-16(a5)
	move.l	4(a1),4(a5)
	move.l	4(a1),-12(a5)
	move.l	8(a1),8(a5)
	move.l	8(a1),-8(a5)
	move.l	12(a1),12(a5)
	move.l	12(a1),-4(a5)
	lea	(-16.w,a1),a1
	lea	(-32.w,a5),a5
	dbra	d4,.expand
	lea	(1072.w,a1),a1
	lea	(1408.w,a5),a5
	dbra	d5,.main
	move.l	(sp)+,a2
	rts
.shrink
	tst.b	(a2)+
	beq.s	.leave
	sf.b	-1(a2)
	moveq	#21,d4
.loop
	move.l	-624(a5),-304(a1)
	move.l	-620(a5),-300(a1)
	move.l	-616(a5),-296(a1)
	move.l	-612(a5),-292(a1)
	lea	(16.w,a1),a1
	lea	(32.w,a5),a5
	dbra	d4,.loop
	lea	(-336.w,a1),a1
	moveq	#20,d4
.loop1
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	dbra	d4,.loop1
	lea	(384.w,a1),a1
	lea	(32.w,a5),a5
	dbra	d5,.main
	move.l	(sp)+,a2
	rts
.leave
	lea	(736.w,a1),a1
	lea	(736.w,a5),a5
	dbra	d5,.main
	move.l	(sp)+,a2
	rts

KeyRead:
;keyqual	lshift  	- bit 0 set
;		rshift 		- bit 1 set
;		caps lock 	- bit 2 set
;		ctrl 		- bit 3 set
;		lalt = CBM	- bit 4 set

	cmp.b	#-1,KeyBuffer
	beq.s	Nokey

	move.l	a2,-(sp)
	lea	KeyBuffer,a2
	lea	KeyMapTable,a1
	move.b	#-1,(a0)
	moveq	#0,d7
.lp
	move.b	(a2)+,d7
	cmp.b	#-1,d7
	beq.s	.fin

	move.w	(a1,d7.l*2),d6
	move.w	KeyBank,d7
	eor.b	#-1,d7
	and.b	d6,d7
	beq.s	.lp

	ror.w	#8,d6
	and.b	d6,(a0)

	bra.s	.lp
.fin	move.l	(sp)+,a2
	moveq	#0,d7
	rts
Nokey:
	move.b	#-1,(a0)
	moveq	#0,d7
	rts

ColWrite:
	moveq	#0,d7
	moveq	#0,d5
	move.w	a0,d4
	sub.w	#$d800,d4
	move.b	([ScreenAddress],d4.l),d7
	move.w	(ScrLUT,d4.l*2),a5
	add.l	BPL2Address,a5
	lea	([CROMAddy],d7.l*8),a1
	move.b	(a0),d4
	and.w	#15,d4
	move.w	#7,d6
	lea	TextTable,a0
.loop
	move.b	(a1)+,d5
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop
	rts

MCMColWrite:
	moveq	#0,d7
	moveq	#0,d5
	move.w	a0,d4
	sub.w	#$d800,d4
	move.b	([ScreenAddress],d4.l),d7
	move.w	(ScrLUT,d4.l*2),a5
	add.l	BPL2Address,a5
	lea	([CROMAddy],d7.l*8),a1
	move.b	(a0),d4
	move.w	#7,d6
	btst	#3,d4
	beq.s	.mono
	and.w	#7,d4
	move.l	a2,-(sp)
	lea	MultiTextBack,a2
	lea	MultiTextTable,a0
.loop
	move.b	(a1)+,d5
	move.b	(a2,d5.l),(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop
	move.l	(sp)+,a2
	rts

.mono
	lea	TextTable,a0
	and.w	#15,d4
.loop1
	move.b	(a1)+,d5
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop1
	moveq	#0,d7
	rts

ECMColWrite:
	moveq	#0,d7
	moveq	#0,d5
	move.w	a0,d4
	sub.w	#$d800,d4
	move.w	(ScrLUT,d4.l*2),a5
	add.l	BPL2Address,a5
	move.b	([ScreenAddress],d4.l),d5
	move.b	d5,d7
	and.w	#63,d5
	lea	([CROMAddy],d5.l*8),a1
	move.b	(a0),d4
	and.w	#15,d4
	move.w	#7,d6
	lea	TextTable,a0

	btst	#7,d7
	bne.s	.bit7
	btst	#6,d7
	bne	.bit6
.loop
	move.b	(a1)+,d5
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop
	moveq	#0,d7
	rts

.bit7
	btst	#6,d7
	bne	.bit76
.loop1
	move.b	(a1)+,d5
	move.b	d5,d7
	eor.b	#255,d7
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	or.b	d5,d7
	move.b	d7,(8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop1
	rts

.bit6
	move.b	(a1)+,d5
	move.b	d5,d7
	eor.b	#255,d7
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	or.b	d5,d7
	move.b	d7,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.bit6
	rts

.bit76
	move.b	(a1)+,d5
	move.b	d5,d7
	eor.b	#255,d7
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
 	or.b	d5,d7
	move.b	d7,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.bit76
	rts

DoScreen:
	moveq	#0,d7
	moveq	#0,d5
	move.w	a0,d4
	and.l	#1023,d4
	move.b	(a0),d5
	move.w	(ScrLUT,d4.l*2),a5
	add.l	BPL2Address,a5
	lea	([CROMAddy],d5.l*8),a1
	move.w	d4,d6
	add.w	#$d800,d6
	move.l	d6,a0
	add.l	CharROMSwitch,a0
	move.b	(a0),d4
	and.w	#15,d4
	move.w	#7,d6
	lea	TextTable,a0
.loop
	move.b	(a1)+,d5
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop
	rts

DoECM:
	moveq	#0,d7
	moveq	#0,d5
	move.w	a0,d4
	and.l	#1023,d4
	move.b	(a0),d5
	move.b	d5,d7
	and.b	#63,d5
	move.w	(ScrLUT,d4.l*2),a5
	add.l	BPL2Address,a5
	lea	([CROMAddy],d5.l*8),a1
	move.w	d4,d6
	add.w	#$d800,d6
	move.l	d6,a0
	add.l	CharROMSwitch,a0
	move.b	(a0),d4
	and.w	#15,d4
	lea	TextTable,a0
	move.w	#7,d6

	btst	#7,d7
	bne.s	.bit7
	btst	#6,d7
	bne	.bit6
.loop
	move.b	(a1)+,d5
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop
	rts

.bit7
	btst	#6,d7
	bne	.bit76
.loop1
	move.b	(a1)+,d5
	move.b	d5,d7
	eor.b	#255,d7
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	or.b	d5,d7
	move.b	d7,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop1
	rts

.bit6
	move.b	(a1)+,d5
	move.b	d5,d7
	eor.b	#255,d7
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	or.b	d5,d7
	move.b	d7,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.bit6
	rts

.bit76
	move.b	(a1)+,d5
	move.b	d5,d7
	eor.b	#255,d7
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
 	or.b	d5,d7
	move.b	d7,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.bit76
	moveq	#0,d7
	rts

MCMWrite:
	move.l	a2,-(sp)
	moveq	#0,d7
	moveq	#0,d5
	move.w	a0,d4
	and.l	#1023,d4
	move.b	(a0),d5
	move.w	(ScrLUT,d4.l*2),a5
	add.l	BPL2Address,a5
	lea	([CROMAddy],d5.l*8),a1
	move.w	d4,d6
	add.w	#$d800,d6
	move.l	d6,a0
	add.l	CharROMSwitch,a0
	move.b	(a0),d4
	and.w	#15,d4
	move.w	#7,d6
	cmp.b	#8,d4
	blo.s	.mono
	and.w	#7,d4
	lea	MultiTextBack,a2
	lea	MultiTextTable,a0
.loop
	move.b	(a1)+,d5
	move.b	(a2,d5.l),(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop
	move.l	(sp)+,a2
	rts
.mono
	lea	TextTable,a0
.loop1
	move.b	(a1)+,d5
	move.b	d5,(24000.w,a5)
	lsl.w	#4,d5
	add.w	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop1
	move.l	(sp)+,a2
	rts

MonoBMM:
	moveq	#0,d7
	move.l	BitPlaneTable,a1
	move.w	(a0),d4
	move.w	a0,d5
	and.l	#$1fff,d5
	move.w	(BMLUT,d5.l*2),a5		;gets amiga bpls position
	add.l	BPL2Address,a5
	lsr.w	#3,d5
	add.l	ScreenAddress,d5		;gets colour to use
	move.l	d5,a0
	move.b	(a0),d4
	move.l	(a1,d4.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	move.b	#-1,(24000.w,a5)
	rts

BMMColour:
	moveq	#0,d7
	move.w	#7,d6
	move.w	a0,d4
	and.l	#$3ff,d4
	lsl.w	#3,d4
	move.w	(BMLUT,d4.l*2),a5
	add.l	BPL2Address,a5
	lea	([CharAddress],d4.l),a1
	move.b	(a0),d4			;colour
	moveq	#0,d5
	move.l	BitPlaneTable,a0
.loop
	move.w	(a1),d5
	move.b	d4,d5
	move.l	(a0,d5.l*4),d5
	move.b	d5,(-8000.w,a5)
	lsr.l	#8,d5
	move.b	d5,(a5)
	lsr.l	#8,d5
	move.b	d5,(8000.w,a5)
 	lsr.l	#8,d5
	move.b	d5,(16000.w,a5)
	move.b	#-1,(24000.w,a5)
	lea	(40.w,a5),a5
	addq.l	#1,a1
	dbra	d6,.loop
	rts

MultiBMM:
	moveq	#0,d7
	move.b	(a0),d7
	move.w	a0,d4
	and.l	#$1fff,d4
	move.w	(BMLUT,d4.l*2),a5		;gets amiga bpls position
	add.l	BPL2Address,a5
	lsr.w	#3,d4
	move.w	d4,d6
	add.w	#$d800,d6
	move.l	d6,a0
	add.l	CharROMSwitch,a0
	moveq	#0,d5
	move.b	(a0),d5
	lsl.w	#4,d7
	add.w	d7,d5
	add.l	ScreenAddress,d4		;gets colour to use
	move.l	d4,a0
	lsl.w	#4,d7
	move.b	(a0),d7
	move.l	([MultiTable],d7.l*4),d4
	and.l	(MCMColour,d5.l*4),d4
	move.b	d4,(-8000.w,a5)
	lsr.l	#8,d4
	move.b	d4,(a5)
	lsr.l	#8,d4
	move.b	d4,(8000.w,a5)
	lsr.l	#8,d4
	move.b	d4,(16000.w,a5)
	lsr.w	#8,d7
	move.b	(MCMBackground,d7.l),(24000.w,a5)
	moveq	#0,d7
	rts

MBMMColour:
	movem.l	d3/a3/a4,-(sp)
	moveq	#0,d5
	move.w	a0,d4
	move.b	(a0),d7
	and.l	#1023,d4
	move.w	d4,d6
	lsl.w	#3,d4
	move.w	(BMLUT,d4.l*2),a5
	add.l	BPL2Address,a5
	lea	([CharAddress],d4.l),a1
	add.w	#$d800,d6
	move.l	d6,a0
	add.l	CharROMSwitch,a0
	move.b	(a0),d5
	move.w	#7,d6
	move.l	MultiTable,a0
	lea	MCMBackground,a3
	lea	MCMColour,a4
.loop
	move.w	(a1),d4
	move.b	d7,d4
	move.l	(a0,d4.l*4),d3
	moveq	#0,d4
	move.b	(a1)+,d4
	move.b	(a3,d4.l),(24000.w,a5)
	lsl.w	#4,d4
	add.w	d5,d4
	and.l	(a4,d4.l*4),d3
	move.b	d3,(-8000.w,a5)
	lsr.l	#8,d3
	move.b	d3,(a5)
	lsr.l	#8,d3
	move.b	d3,(8000.w,a5)
	lsr.l	#8,d3
	move.b	d3,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop
	moveq	#0,d7
	movem.l	(sp)+,d3/a3/a4
	rts

MBMMColWrite:
	movem.l	d3/a3/a4,-(sp)
	moveq	#0,d5
	move.l	a0,d6
	add.l	CharROMSwitch,a0
	move.b	(a0),d5
	sub.w	#$d800,d6
	move.w	d6,d4
	lsl.w	#3,d4
	move.w	(BMLUT,d4.l*2),a5
	add.l	BPL2Address,a5
	lea	([CharAddress],d4.l),a1
	add.w	MCRLast,d6
	move.l	d6,a0
	move.b	(a0),d7
	move.w	#7,d6
	move.l	MultiTable,a0
	lea	MCMBackground,a3
	lea	MCMColour,a4
.loop
	move.w	(a1),d4
	move.b	d7,d4
	move.l	(a0,d4.l*4),d3
	moveq	#0,d4
	move.b	(a1)+,d4
	move.b	(a3,d4.l),(24000.w,a5)
	lsl.w	#4,d4
	add.w	d5,d4
	and.l	(a4,d4.l*4),d3
	move.b	d3,(-8000.w,a5)
	lsr.l	#8,d3
	move.b	d3,(a5)
	lsr.l	#8,d3
	move.b	d3,(8000.w,a5)
	lsr.l	#8,d3
	move.b	d3,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d6,.loop
	moveq	#0,d7
	movem.l	(sp)+,d3/a3/a4
	rts


	cnop	0,4

rts:
	move.w	a3,d6
	addq.b	#1,d6
	move.l	d6,a0
	move.b	(a0),d5
	lsl.w	#8,d5
	addq.b	#1,d6
	move.l	d6,a0
	move.b	(a0),d5
	ror.w	#8,d5
	move.l	d6,a3
	move.w	d5,d6
	move.l	d6,a4
	addq.w	#1,a4
	jmp	start2

	cnop	0,4

Brk:
	jmp	Freak

	cnop	0,4

orax:
	InsAX
	RWChk2
	or.b	(a0),d0	
	FlagNZ
	jmp	start2

	cnop	0,4

ascii:
	jmp	Freak

	cnop	0,4

oraz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

aslz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	add.b	d6,d6
	FlagCNZ
	move.b	d6,(a0)
	ZeroP


	cnop	0,4

php:
	lea	ACTable,a1
	PackA
	move.b	(a1,d7),(a3)
	move.w	a3,d6
	subq.b	#1,d6
	move.l	d6,a3
	jmp	start2

	cnop	0,4

orah:
	or.b	(a4)+,d0
	FlagNZ
	jmp	start2

	cnop	0,4

asla:
	add.b	d0,d0
	FlagCNZ
	jmp	start2

	cnop	0,4

ora:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	or.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

asl:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	add.b	d6,d6
	FlagCNZ
	move.b	d6,(a0)
	RWChk

	cnop	0,4

bpl:
	move.b	(a4)+,d6
	btst	#3,d3
	bne.w	start2
	ext.w	d6
	add.w	d6,a4
	jmp	start2

	cnop	0,4

oray:
	InsAY
	RWChk2
	or.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

orax1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

aslx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	add.b	d6,d6
	FlagCNZ
	move.b	d6,(a0)
	ZeroP

	cnop	0,4

clc:
	bclr	#0,d3
	jmp	start2

	cnop	0,4

oray1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	or.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

orax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	or.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

aslx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	add.b	d6,d6
	FlagCNZ
	move.b	d6,(a0)
	RWChk
	
	cnop	0,4

jsr:
	move.w	(a4),d6
	ror.w	#8,d6
	addq.w	#1,a4
	move.w	a4,d5
	move.l	d6,a4
	move.l	a3,d6
	subq.b	#1,d6
	move.l	d6,a0
	move.b	d5,(a0)
	lsr.w	#8,d5
	addq.b	#1,d6
	move.l	d6,a0
	move.b	d5,(a0)
	subq.b	#2,d6
	move.l	d6,a3
	jmp	start2

	cnop	0,4

andx:
	InsAX
	RWChk2
	and.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

bitz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	move.b	d6,d5
	and.b	#1,d3

	asr.b	#5,d5
	and.w	#10,d5
	and.b	d0,d6
	move	ccr,d6
	or.b	d6,d5
	or.b	d5,d3

	jmp	start2

	cnop	0,4

andz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

rolz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROL	d6
	move.b	d6,(a0)
	ZeroP

	cnop	0,4

plp:
	move.l	a3,d6
	addq.b	#1,d6
	move.l	d6,a3
	moveq	#0,d3
	move.b	(a3),d3
	lea	CATable,a1
	move.b	(a1,d3.l),d3
	UnPackA
	jmp	start2
	cnop	0,4

andh:
	and.b	(a4)+,d0
	FlagNZ
	jmp	start2

	cnop	0,4

rola:
	FlagROL	d0
	jmp	start2

	cnop	0,4

bit:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	move.b	d6,d5
	and.b	#1,d3

	asr.b	#5,d5
	and.w	#10,d5
	and.b	d0,d6
	move	ccr,d6
	or.b	d6,d5
	or.b	d5,d3

	jmp	start2

	cnop	0,4

and:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	and.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

rol:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	FlagROL	d6
	move.b	d6,(a0)
	RWChk

	cnop	0,4

bmi:
	move.b	(a4)+,d6
	btst	#3,d3
	beq.w	start2
	ext.w	d6
	add.w	d6,a4
	jmp	start2

	cnop	0,4

andy:
	InsAY
	RWChk2
	and.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

andx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

rolx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROL	d6
	move.b	d6,(a0)
	ZeroP

	cnop	0,4

sec:
	bset	#0,d3
	jmp	start2

	cnop	0,4

andy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	and.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

andx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	and.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

rolx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	FlagROL	d6
	move.b	d6,(a0)
	RWChk

	cnop	0,4

rti:
	move.w	a3,d6
	addq.b	#1,d6
	move.l	d6,a0
	moveq	#0,d3
	move.b	(a0),d3
	lea	CATable,a1
	move.b	(a1,d3.l),d3
	UnPackA
	sf.b	IDF
	sf.b	IRQ
	addq.b	#2,d6
	move.l	d6,a0
	move.b	(a0),d5
	lsl.w	#8,d5
	subq.b	#1,d6
	move.l	d6,a0
	move.b	(a0),d5
	addq.b	#1,d6
	move.l	d6,a3
	move.w	d5,d6
	move.l	d6,a4
	jmp	start2

	cnop	0,4

eorx:
	InsAX
	RWChk2
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	jmp	start2

	cnop	0,4

eorz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	jmp	start2

	cnop	0,4

lsrz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	FlagLSR
	move.b	d6,(a0)
	ZeroP

	cnop	0,4

pha:
	move.b	d0,(a3)
	move.l	a3,d6
	subq.b	#1,d6
	move.l	d6,a3
	jmp	start2

	cnop	0,4

eorh:
	move.b	(a4)+,d6
	eor.b	d6,d0
	FlagNZ
	jmp	start2

	cnop	0,4

lsra:
	lsr.b	d0
	FlagLSR
	jmp	start2

	cnop	0,4

jmp:
	move.w	(a4),d6
	ror.w	#8,d6
	move.l	d6,a4
	jmp	start2

	cnop	0,4

eor:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	jmp	start2

	cnop	0,4

lsr:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	lsr.b	d6
	FlagLSR
	move.b	d6,(a0)
	RWChk
	
	cnop	0,4

bvc:
	move.b	(a4)+,d6
	btst	#1,d3
	bne.w	start2
	ext.w	d6
	add.w	d6,a4
	jmp	start2

	cnop	0,4

eory:
	InsAY
	RWChk2
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	jmp	start2

	cnop	0,4

eorx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	jmp	start2

	cnop	0,4

lsrx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	FlagLSR
	move.b	d6,(a0)
	ZeroP

	cnop	0,4

cli:
	move.b	IntSR,d5
	beq.s	.over
	move.w	#1,CISData
	btst	#0,d5
	beq.s	.notta
	bclr	#0,d5
	bra.s	.over1
.notta
	btst	#1,d5
	beq.s	.nottb
	bclr	#1,d5
	bra.s	.over1
.nottb
	btst	#2,d5
	beq.s	.over1
	bclr	#2,d5
.over1
	move.b	d5,IntSR
.over
	sf.b	IDF
	bclr	#16,d3
	jmp	start2

	cnop	0,4

eory1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	jmp	start2

	cnop	0,4

eorx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	jmp	start2

	cnop	0,4

lsrx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	lsr.b	d6
	FlagLSR
	move.b	d6,(a0)
	RWChk

	cnop	0,4

adcx:
	InsAX
	RWChk2
	move.b	(a0),d6
	FlagADD
	jmp	start2

	cnop	0,4

adcz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	jmp	start2

	cnop	0,4

rorz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	ZeroP

	cnop	0,4

pla:
	move.l	a3,d6
	addq.b	#1,d6
	move.l	d6,a3
	move.b	(a3),d0
	FlagNZ
	jmp	start2

	cnop	0,4

adch:
	move.b	(a4)+,d6
	FlagADD
	jmp	start2
	
	cnop	0,4

rora:
	FlagROR	d0
	jmp	start2

	cnop	0,4

jmpi:
	move.w	(a4),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d5
	lsl.w	#8,d5
	addq.b	#1,d6
	move.l	d6,a0
	move.b	(a0),d5
	ror.w	#8,d5
	move.w	d5,d6
	move.l	d6,a4
	jmp	start2

	cnop	0,4

adc:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	FlagADD
	jmp	start2

	cnop	0,4

ror:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	RWChk

	cnop	0,4

bvs:
	move.b	(a4)+,d6
	btst	#1,d3
	beq.w	start2
	ext.w	d6
	add.w	d6,a4
	jmp	start2

	cnop	0,4

adcy:
	InsAY
	RWChk2
	move.b	(a0),d6
	FlagADD
	jmp	start2

	cnop	0,4

adcx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	jmp	start2

	cnop	0,4

rorx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	ZeroP

	cnop	0,4

sei:
	bset	#16,d3
	st.b	IDF
	move.w	#0,CISData
	jmp	start2

	cnop	0,4

adcy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	FlagADD
	jmp	start2

	cnop	0,4

adcx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	FlagADD
	jmp	start2
	
	cnop	0,4

rorx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	RWChk

	cnop	0,4

stax:
	InsAX
	move.b	d0,(a0)
	RWChk

	cnop	0,4

styz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	d2,(a0)
	ZeroP

	cnop	0,4

staz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	d0,(a0)
	ZeroP

	cnop	0,4

stxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	d1,(a0)
	ZeroP

	cnop	0,4

dey:
	subq.b	#1,d2
	FlagNZ
	jmp	start2

	cnop	0,4

txa:
	move.b	d1,d0
	FlagNZ
	jmp	start2

	cnop	0,4

sty:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	d2,(a0)
	RWChk

	cnop	0,4

sta:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	d0,(a0)
	RWChk

	cnop	0,4

stx:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	d1,(a0)
	RWChk

	cnop	0,4

bcc:
	move.b	(a4)+,d6
	btst	#0,d3
	bne.w	start2
	ext.w	d6
	add.w	d6,a4
	jmp	start2

	cnop	0,4

stay:
	InsAY
	move.b	d0,(a0)
	RWChk

	cnop	0,4

styx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	d2,(a0)
	ZeroP

	cnop	0,4

stax1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	d0,(a0)
	ZeroP

	cnop	0,4

stxy1z:
	move.w	d2,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	d1,(a0)
	ZeroP

	cnop	0,4

tya:
	move.b	d2,d0
	FlagNZ
	jmp	start2

	cnop	0,4

stay1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	d0,(a0)
	RWChk

	cnop	0,4

txs:
	move.w	d1,a3
	lea	(256.w,a3),a3
	add.l	Address,a3
	jmp	start2

	cnop	0,4

stax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	d0,(a0)
	RWChk
	
	cnop	0,4

ldyh:
	move.b	(a4)+,d2
	FlagNZ
	jmp	start2

	cnop	0,4

ldax:
	InsAX
	RWChk2
	move.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

ldxh:
	move.b	(a4)+,d1
	FlagNZ
	jmp	start2

	cnop	0,4

ldyz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d2
	FlagNZ
	jmp	start2

	cnop	0,4

ldaz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

ldxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d1
	FlagNZ
	jmp	start2

	cnop	0,4

tay:
	move.b	d0,d2
	FlagNZ
	jmp	start2
	
	cnop	0,4
		
ldah:
	move.b	(a4)+,d0
	FlagNZ
	jmp	start2

	cnop	0,4

tax:
	move.b	d0,d1
	FlagNZ
	jmp	start2

	cnop	0,4

ldy:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d2
	FlagNZ
	jmp	start2
	
	cnop	0,4

lda:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

ldx:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d1
	FlagNZ
	jmp	start2

	cnop	0,4

bcs:
	move.b	(a4)+,d6
	btst	#0,d3
	beq.w	start2
	ext.w	d6
	add.w	d6,a4
	jmp	start2

	cnop	0,4

lday:
	InsAY
	RWChk2
	move.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

ldyx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d2
	FlagNZ
	jmp	start2

	cnop	0,4

ldax1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

ldxy1z:
	move.w	d2,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d1
	FlagNZ
	jmp	start2

	cnop	0,4

clv:
	bclr	#1,d3
	jmp	start2

	cnop	0,4

lday1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

tsx:
	move.w	a3,d1
	sub.w	#256,d1
	FlagNZ
	jmp	start2

	cnop	0,4

ldyx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d2
	FlagNZ
	jmp	start2

	cnop	0,4

ldax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d0
	FlagNZ
	jmp	start2

	cnop	0,4

ldxy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d1
	FlagNZ
	jmp	start2

	cnop	0,4

cpyh:
	cmp.b	(a4)+,d2
	FlagCMP
	jmp	start2

	cnop	0,4

cmpx:
	InsAX
	RWChk2
	cmp.b	(a0),d0
	FlagCMP
	jmp	start2
	
	cnop	0,4

cpyz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	cmp.b	(a0),d2
	FlagCMP
	jmp	start2

	cnop	0,4

cmpz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	jmp	start2

	cnop	0,4

decz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	FlagNZ
	ZeroP

	cnop	0,4

iny:
	addq.b	#1,d2
	FlagNZ
	jmp	start2

	cnop	0,4

cmph:
	cmp.b	(a4)+,d0
	FlagCMP
	jmp	start2

	cnop	0,4

dex:
	subq.b	#1,d1
	FlagNZ
	jmp	start2

	cnop	0,4

cpy:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	cmp.b	(a0),d2
	FlagCMP
	jmp	start2

	cnop	0,4

cmp:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	cmp.b	(a0),d0
	FlagCMP
	jmp	start2

	cnop	0,4

dec:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	subq.b	#1,(a0)
	FlagNZ
	RWChk

	cnop	0,4

bne:
	move.b	(a4)+,d6
	btst	#2,d3
	bne.w	start2
	ext.w	d6
	add.w	d6,a4
	jmp	start2

	cnop	0,4

cmpy:
	InsAY
	RWChk2
	cmp.b	(a0),d0
	FlagCMP
	jmp	start2

	cnop	0,4

cmpx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	jmp	start2

	cnop	0,4

decx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	FlagNZ
	ZeroP

	cnop	0,4

cld:
	bclr	#17,d3
	jmp	start2

	cnop	0,4

cmpy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	cmp.b	(a0),d0
	FlagCMP
	jmp	start2

	cnop	0,4

cmpx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	cmp.b	(a0),d0
	FlagCMP
	jmp	start2

	cnop	0,4

decx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	subq.b	#1,(a0)
	FlagNZ
	RWChk

	cnop	0,4

cpxh:
	cmp.b	(a4)+,d1
	FlagCMP
	jmp	start2

	cnop	0,4

sbcx:
	InsAX
	RWChk2
	move.b	(a0),d6
	FlagSUB
	jmp	start2

	cnop	0,4

cpxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	cmp.b	(a0),d1
	FlagCMP
	jmp	start2

	cnop	0,4

sbcz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	jmp	start2

	cnop	0,4

incz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	FlagNZ
	ZeroP

	cnop	0,4

inx:
	addq.b	#1,d1
	FlagNZ
	jmp	start2

	cnop	0,4

sbch:
	move.b	(a4)+,d6
	FlagSUB
	jmp	start2

	cnop	0,4

nop:
	jmp	start2

	cnop	0,4

cpx:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	cmp.b	(a0),d1
	FlagCMP
	jmp	start2

	cnop	0,4

sbc:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	FlagSUB
	jmp	start2

	cnop	0,4

inc:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	addq.b	#1,(a0)
	FlagNZ
	RWChk

	cnop	0,4

beq:
	move.b	(a4)+,d6
	btst	#2,d3
	beq.w	start2
	ext.w	d6
	add.w	d6,a4
	jmp	start2

	cnop	0,4

sbcy:
	InsAY
	RWChk2
	move.b	(a0),d6
	FlagSUB
	jmp	start2

	cnop	0,4

sbcx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	jmp	start2

	cnop	0,4

incx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	FlagNZ
	ZeroP

	cnop	0,4

sed:
	bset	#17,d3
	jmp	start2

	cnop	0,4

sbcy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	FlagSUB
	jmp	start2

	cnop	0,4

sbcx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	FlagSUB
	jmp	start2

	cnop	0,4

incx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	addq.b	#1,(a0)
	FlagNZ
	RWChk

	cnop	0,4

****	UN-DOCUMENTED 6510 OP-CODES	*****
****	THESE WILL BE UNTESTED FOR A	*****
****	WHILE. SO DO NOT TRY TO USE	*****

JAM:	
	jmp	Freak

	cnop	0,4

arrh:
	and.b	(a4)+,d0
	FlagROR	d0
	jmp	start2

asrh:
	and.b	(a4)+,d0
	lsr.b	d0
	FlagLSR
	jmp	start2

anch:
	and.b	(a4)+,d0
	move	ccr,d5
	and.w	#3,d3
	and.w	#12,d5
	or.b	d5,d3
	btst	#3,d5
	beq.s	.over
	bset	#0,d3
.over
	jmp	start2

aneh:
	move.w	d1,d0
	and.b	(a4)+,d0
	FlagNZ
	jmp	start2

lxah:
	move.b	(a4)+,d6
	and.b	d6,d1
	and.b	d6,d0
	rts

	cnop	0,4

laey1:
	move.w	a3,d1
	sub.w	#256,d1
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	and.b	d6,d1
	FlagNZ
	move.b	d1,d0
	move.w	d1,a3
	lea	(256.w,a3),a3
	add.l	Address,a3
	jmp	start2

slox:
	InsAX
	RWChk2
	move.b	(a0),d6
	add.b	d6,d6
	FlagCNZ
	or.b	d6,d0
	FlagNZ
	move.b	d6,(a0)
	RWChk

sloz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	add.b	d6,d6
	FlagCNZ
	or.b	d6,d0
	FlagNZ
	move.b	d6,(a0)
	ZeroP

slo:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	add.b	d6,d6
	FlagCNZ
	or.b	d6,d0
	FlagNZ
	move.b	d6,(a0)
	RWChk

sloy:
	InsAY
	RWChk2
	move.b	(a0),d6
	add.b	d6,d6
	FlagCNZ
	or.b	d6,d0
	FlagNZ
	move.b	d6,(a0)
	RWChk

slox1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	add.b	d6,d6
	FlagCNZ
	or.b	d6,d0
	FlagNZ
	move.b	d6,(a0)
	ZeroP

sloy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	add.b	d6,d6
	FlagCNZ
	or.b	d6,d0
	FlagNZ
	move.b	d6,(a0)
	RWChk

slox1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	add.b	d6,d6
	FlagCNZ
	or.b	d6,d0
	FlagNZ
	move.b	d6,(a0)
	RWChk

rlax:
	InsAX
	RWChk2
	move.b	(a0),d6
	rol.b	d6
	and.b	d0,d6
	FlagNZ
	move.b	d6,(a0)
	RWChk

rlaz:
	sub.w	d6,d6
	move.w	(a4)+,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	rol.b	d6
	and.b	d0,d6
	FlagNZ
	move.b	d6,(a0)
	ZeroP

rla:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	rol.b	d6
	and.b	d0,d6
	FlagNZ
	move.b	d6,(a0)
	RWChk

rlay:
	InsAY
	RWChk2
	move.b	(a0),d6
	rol.b	d6
	and.b	d0,d6
	FlagNZ
	move.b	d6,(a0)
	RWChk

rlax1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	rol.b	d6
	and.b	d0,d6
	FlagNZ
	move.b	d6,(a0)
	ZeroP

rlay1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	rol.b	d6
	and.b	d0,d6
	FlagNZ
	move.b	d6,(a0)
	RWChk

rlax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	rol.b	d6
	and.b	d0,d6
	FlagNZ
	move.b	d6,(a0)
	RWChk

srex:
	InsAX
	RWChk2
	move.b	(a0),d6
	lsr.b	#1,d6
	eor.b	d0,d6
	FlagNZ
	move.b	d6,(a0)
	RWChk2

srez:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	#1,d6
	eor.b	d0,d6
	FlagNZ
	move.b	d6,(a0)
	RWChk

sre:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	lsr.b	#1,d6
	eor.b	d0,d6
	FlagNZ
	move.b	d6,(a0)
	RWChk

srey:
	InsAY
	RWChk2
	move.b	(a0),d6
	lsr.b	#1,d6
	eor.b	d0,d6
	FlagNZ
	RWChk
	
srex1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	#1,d6
	eor.b	d0,d6
	FlagNZ
	RWChk

srey1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	lsr.b	#1,d6
	eor.b	d0,d6
	FlagNZ
	RWChk
		
srex1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	lsr.b	#1,d6
	eor.b	d0,d6
	FlagNZ
	move.b	d6,(a0)
	RWChk

rrax:
	InsAX
	RWChk2
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	FlagADD
	RWChk

rraz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	FlagADD
	ZeroP

rra:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	FlagADD
	RWChk

rray:
	InsAY
	RWChk2
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	FlagADD
	RWChk

rrax1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	FlagADD
	ZeroP

rray1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	FlagADD
	RWChk

rrax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	FlagADD
	RWChk

shay:
	InsAY
	RWChk2
	move.w	d6,d5
	ror.w	#8,d5
	move.w	d0,d6
	and.w	d1,d6
	and.b	d5,d6
	move.b	d6,(a0)
	RWChk

shay1:
	move.w	(a4)+,d6
	move.b	d6,d5			;part of sha
	addq.b	#1,d5			;
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	move.w	d0,d6
	and.w	d1,d6
	and.b	d5,d6			;look here to see why
	move.b	d6,(a0)
	RWChk


saxx:					;VERY weird
	InsAX
	move.w	d0,d6
	and.w	d1,d6
	move.b	d6,(a0)
	RWChk

saxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	move.b	d6,(a0)
	ZeroP

sax:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	move.b	d6,(a0)
	RWChk

saxy1z:
	move.w	d2,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	move.b	d6,(a0)
	RWChk

shsy1:
	move.w	(a4)+,d6
	move.b	d6,d5
	addq.b	#1,d5
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	move.w	d6,a3
	lea	(256.w,a3),a3
	add.l	Address,a3
	and.b	d5,d6
	move.b	d6,(a0)
	RWChk

shyy1:
	move.w	(a4)+,d6
	move.b	d6,d5
	addq.b	#1,d5
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	and.b	d2,d5
	move.b	d6,(a0)
	RWChk

shxx1:
	move.w	(a4)+,d6
	move.b	d6,d5
	addq.b	#1,d5
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	and.b	d1,d5
	move.b	d6,(a0)
	RWChk

laxx:
	InsAX
	RWChk2
	move.b	(a0),d0
	move.b	d0,d1
	FlagNZ
	jmp	start

laxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d0
	move.b	d0,d1
	FlagNZ
	jmp	start2

laxh:
	move.b	(a4)+,d0
	move.b	d0,d1
	FlagNZ
	jmp	start2

lax:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d0
	move.b	d0,d1
	FlagNZ
	jmp	start2

laxy:
	InsAY
	RWChk2
	move.b	(a0),d0
	move.b	d0,d1
	FlagNZ
	jmp	start2


laxy1z:
	move.w	d2,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d0
	move.b	d0,d1
	FlagNZ
	jmp	start2

laxy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	move.b	(a0),d0
	move.b	d0,d1
	FlagNZ
	jmp	start2

lasy1:				;WEIRD!
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.w	a3,d6
	sub.w	#256,d6
	and.b	(a0),d6
	FlagNZ
	move.b	d6,d0
	move.b	d6,d1
	move.w	d1,a3
	lea	(256.w,a3),a3
	add.l	Address,a3
	jmp	start2

dcpx:
	InsAX
	RWChk2
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	RWChk

dcpz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	ZeroP

dcp:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	RWChk

dcpy:
	InsAY
	RWChk2
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	RWChk

dcpx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	ZeroP

dcpy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	RWChk

dcpx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	RWChk

isbx:
	InsAX
	RWChk2
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	RWChk

isbz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	ZeroP

isb:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	RWChk2
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	RWChk

isby:
	InsAY
	RWChk2
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	RWChk

isbx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	ZeroP

isby1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	RWChk2
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	RWChk

isbx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	RWChk2
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	RWChk

sbxh:
	and.w	d0,d1
	sub.b	(a4)+,d1
	FlagCMP
	jmp	start2

	cnop	0,4

UCopAddy:
	dc.l	0
InputEF:
	dc.l	0,0
	dc.b	2,52
	dc.l	InputName
	dc.l	0,InputHandler

InputName:
	dc.b	"Test InputHandler",0
	even
MySig:
	dc.l	0

MyTask:
	dc.l	0

MyInt:	dc.l	0

	cnop	0,4
TIMERA_IS:
	dc.l	0,0
	dc.b	2		; Type: Interrupt
	dc.b	0		; Pri: 0
	dc.l	TimerA_Name	
	dc.l	MyInt		; Data to be used...
	dc.l	TimerA_Int	; ^ code

TimerA_Name:	
	dc.b	"E42 CIA-B Timer A",0
	cnop	0,4

TIMERB_IS:
	dc.l	0,0
	dc.b	2		; Type: Interrupt
	dc.b	0		; Pri: 0
	dc.l	TimerB_Name	
	dc.l	MyInt		; Data to be used...
	dc.l	TimerA_Int	; ^ code

TimerB_Name:	
	dc.b	"E42 CIA-B Timer B",0

	cnop	0,4
CIA1TAHI	dc.b	0
CIA1TALO	dc.b	0
CIA1TBHI	dc.b	0
CIA1TBLO	dc.b	0

	cnop	0,4
IntsSet		dc.l	0
CIAbBase	dc.l	0
CIAbName	dc.b	'ciab.resource',0
		cnop	0,4
idevname:	dc.b	'input.device',0
		cnop	0,4
InputEP:	dcb.b	34,0
		cnop	0,4
IEIOReq:	dcb.b	48,0

		cnop	0,4

StackSave:	dc.l	0

consolname:	dc.b	'CON:0/100/640/100/Debug',0
		even
conhandle:	dc.l	0
		
dosname:	dc.b	'dos.library',0
		even
dosbase:	dc.l	0

intuname:	dc.b	'intuition.library',0
		even
IntBase:	dc.l	0

GfxName:	dc.b	'graphics.library',0
		even
GfxBase:	dc.l	0

RTname:		dc.b	'reqtools.library',0
		even
RTBase:		dc.l	0

freq:		dc.l	0

locksav:	dc.l	0

windowhd:	dc.l	0

filehd:		dc.l	0

file64hd:	dc.l	0

test:		dc.l	0

RTitle:		dc.b	'Select A File',0

kernal:		dc.b	'42Emu:64KernalROM',0

basic:		dc.b	'42Emu:64BasicROM',0

char:		dc.b	'42Emu:64CharROM',0

errmsg:		dc.b	"I/O Error!",0
		even
taskpt:		dc.l	0

taskoldwin:	dc.l	0

linef:		dc.b	10,13

BufferP:	dc.b	0
		even

bufflen:	dc.l	0

filename:	dcb.b	16,0

Buffer:		dcb.b	20,0

Buffer2:	dcb.b	256,0

decbuff:
		dcb.b	16,0

inbuff:		dcb.b	128,0

		cnop	0,4
FileInfo:	dcb.b	260,0

		cnop	0,4

dir64:		dc.b	"DH2:Trashcan/64Games1",0

		cnop	0,4
pat64:		dc.b	"",0
		cnop	0,4

PubScreenName:
		cnop	0,4
		dc.b	"Workbench",0
		cnop	0,4

RRepeat:	dc.l	0	; defines repeated read True/False
		
myreqtag:	dc.l $80000032,dir64	; RTFI_Dir
		dc.l $80000033,pat64	; RTFI_MatchPat
		dc.l 0,0
freqtags:
		dc.l $80000028,$8	; ONLY Directories
		dc.l $80000006,PubScreenName
		dc.l 0,0

BPL1Address:
		dc.l	0
BPL2Address:
		dc.l	0
BPL3Address:
		dc.l	0
BPL4Address:
		dc.l	0
BPL5Address:
		dc.l	0

JoyTable:
		dc.b	15
		dc.b	13	;down
		dc.b	5	;down-right
		dc.b	7	;right
		dc.b	14	;up
		dc.b	15
		dc.b	15
		dc.b	6	;up-right
		dc.b	10	;up-left
		dc.b	15
		dc.b	15
		dc.b	15
		dc.b	11	;left
		dc.b	9	;down-left
		dc.b	15
		dc.b	15

screen_defs:
		dc.w	4
		dc.w	-17
		dc.w	320
		dc.w	200
		dc.w	0		;no of bpls
		dc.b	17		;colour of text
		dc.b	16		;bkgrnd colour
		dc.w	$4000
		dc.w	256
		dc.l	0
		dc.l	screenname
		dc.l	0
		dc.l	0

window_defs:
		dc.w	0,0
		dc.w	320,200
		dc.b	17,16
		dc.l	0
		dc.l	$11900		;flags
		dc.l	0
		dc.l	0
		dc.l	0
ScreenHD:	dc.l	0
		dc.l	0
		dc.w	320,200
		dc.w	320,200
		dc.w	15

screenname:	dc.b	'64 Emulator',0
		even
colour64:
; 0 - 15
		dcb.w	16,0		;16 blacks
; 16 -31
Palette:	dc.w	$0000		;black
		dc.w	$0fff		;white
		dc.w	$0d00		;red
		dc.w	$00fd		;cyan
		dc.w	$0f0f		;purple
		dc.w	$00d0		;green
		dc.w	$000d		;blue
		dc.w	$0ff0		;yellow
		dc.w	$0f80		;orange
		dc.w	$0840		;brown
		dc.w	$0f88		;lt red
		dc.w	$0444		;grey1
		dc.w	$0888		;grey2
		dc.w	$08f8		;lt green
		dc.w	$088f		;lt blue
		dc.w	$0ccc		;grey3

KeyWSt:	dc.b	0,0

KeyBank:
	dc.w	0
KeySema:
	dc.l	0
KeyBuffer:
	dc.l	-1
	dc.l	-1
	
	include	KeyQualTable.inc

KeyMapTable:
	include	KeyMap.s

	cnop	0,4
	dcb.l	1024,0		; our stack area
table:
	dc.l	Brk		;00
	dc.l	orax
	dc.l	JAM		;un-doc
	dc.l	slox		;un-doc
	dc.l	nop		;un-doc
	dc.l	oraz
	dc.l	aslz
	dc.l	sloz		;un-doc
	dc.l	php
	dc.l	orah
	dc.l	asla		;10
	dc.l	anch		;un-doc
	dc.l	nop		;un-doc
	dc.l	ora
	dc.l	asl
	dc.l	slo		;un-doc
	dc.l	bpl
	dc.l	oray
	dc.l	JAM		;un-doc
	dc.l	sloy		;un-doc
	dc.l	nop		;un-doc 20
	dc.l	orax1z
	dc.l	aslx1z
	dc.l	slox1z		;un-doc
	dc.l	clc
	dc.l	oray1
	dc.l	nop		;un-doc
	dc.l	sloy1		;un-doc
	dc.l	nop		;un-doc
	dc.l	orax1
	dc.l	aslx1		;30
	dc.l	slox1		;un-doc
	dc.l	jsr
	dc.l	andx
	dc.l	JAM		;un-doc
	dc.l	rlax		;un-doc
	dc.l	bitz
	dc.l	andz
	dc.l	rolz
	dc.l	rlaz		;un-doc
	dc.l	plp		;40
	dc.l	andh
	dc.l	rola
	dc.l	anch		;un-doc
	dc.l	bit
	dc.l	and
	dc.l	rol
	dc.l	rla		;un-doc
	dc.l	bmi
	dc.l	andy
	dc.l	JAM		;un-doc 50
	dc.l	rlay		;un-doc
	dc.l	nop		;un-doc
	dc.l	andx1z
	dc.l	rolx1z
	dc.l	rlax1z		;un-doc
	dc.l	sec
	dc.l	andy1
	dc.l	nop		;un-doc
	dc.l	rlay1		;un-doc
	dc.l	nop		;un-doc 60
	dc.l	andx1
	dc.l	rolx1
	dc.l	rlax1		;un-doc
	dc.l	rti
	dc.l	eorx
	dc.l	JAM		;un-doc
	dc.l	srex		;un-doc
	dc.l	nop		;un-doc
	dc.l	eorz
	dc.l	lsrz		;70
	dc.l	srez		;un-doc
	dc.l	pha
	dc.l	eorh
	dc.l	lsra
	dc.l	asrh		;un-doc
	dc.l	jmp
	dc.l	eor
	dc.l	lsr
	dc.l	sre		;un-doc
	dc.l	bvc		;80
	dc.l	eory
	dc.l	JAM		;un-doc
	dc.l	srey
	dc.l	nop		;un-doc
	dc.l	eorx1z
	dc.l	lsrx1z
	dc.l	srex1z		;un-doc
	dc.l	cli
	dc.l	eory1
	dc.l	nop		;un-doc 90
	dc.l	srey1		;un-doc
	dc.l	nop		;un-doc
	dc.l	eorx1
	dc.l	lsrx1
	dc.l	srex1		;un-doc
	dc.l	rts
	dc.l	adcx
	dc.l	JAM		;un-doc
	dc.l	rrax
	dc.l	nop		;un-doc 100
	dc.l	adcz
	dc.l	rorz
	dc.l	rraz		;un-doc
	dc.l	pla
	dc.l	adch
	dc.l	rora
	dc.l	arrh		;un-doc
	dc.l	jmpi
	dc.l	adc
	dc.l	ror		;110
	dc.l	rra		;un-doc
	dc.l	bvs
	dc.l	adcy
	dc.l	JAM
	dc.l	rray		;un-doc
	dc.l	nop		;un-doc
	dc.l	adcx1z
	dc.l	rorx1z
	dc.l	rrax1z		;un-doc
	dc.l	sei		;120
	dc.l	adcy1
	dc.l	nop		;un-doc
	dc.l	rray1		;un-doc
	dc.l	nop		;un-doc
	dc.l	adcx1
	dc.l	rorx1
	dc.l	rrax1		;un-doc
	dc.l	nop		;un-doc
	dc.l	stax
	dc.l	nop		;un-doc 130
	dc.l	saxx		;un-doc
	dc.l	styz
	dc.l	staz
	dc.l	stxz
	dc.l	saxz		;un-doc
	dc.l	dey
	dc.l	nop		;un-doc
	dc.l	txa
	dc.l	aneh		;un-doc
	dc.l	sty		;140
	dc.l	sta
	dc.l	stx
	dc.l	sax		;un-doc
	dc.l	bcc
	dc.l	stay
	dc.l	JAM
	dc.l	shay		;un-doc
	dc.l	styx1z
	dc.l	stax1z
	dc.l	stxy1z		;150
	dc.l	saxy1z		;un-doc
	dc.l	tya
	dc.l	stay1
	dc.l	txs
	dc.l	shsy1		;un-doc
	dc.l	shyy1		;un-doc
	dc.l	stax1
	dc.l	shxx1		;un-doc
	dc.l	shay1		;un-doc
	dc.l	ldyh		;160
	dc.l	ldax
	dc.l	ldxh
	dc.l	laxx		;un-doc
	dc.l	ldyz
	dc.l	ldaz
	dc.l	ldxz
	dc.l	laxz		;un-doc
	dc.l	tay
	dc.l	ldah
	dc.l	tax		;170
	dc.l	lxah		;un-doc
	dc.l	ldy
	dc.l	lda
	dc.l	ldx
	dc.l	lax		;un-doc
	dc.l	bcs
	dc.l	lday
	dc.l	JAM
	dc.l	laxy		;un-doc
	dc.l	ldyx1z		;180
	dc.l	ldax1z
	dc.l	ldxy1z
	dc.l	laxy1z		;un-doc
	dc.l	clv
	dc.l	lday1
	dc.l	tsx
	dc.l	laey1		;un-doc
	dc.l	ldyx1
	dc.l	ldax1
	dc.l	ldxy1		;190
	dc.l	laxy1		;un-doc
	dc.l	cpyh
	dc.l	cmpx
	dc.l	nop		;un-doc
	dc.l	dcpx		;un-doc
	dc.l	cpyz
	dc.l	cmpz
	dc.l	decz
	dc.l	dcpz		;un-doc
	dc.l	iny		;200
	dc.l	cmph
	dc.l	dex
	dc.l	sbxh		;un-doc
	dc.l	cpy
	dc.l	cmp
	dc.l	dec
	dc.l	dcp		;un-doc
	dc.l	bne
	dc.l	cmpy
	dc.l	JAM		;un-doc 210
	dc.l	dcpy		;un-doc
	dc.l	nop		;un-doc
	dc.l	cmpx1z
	dc.l	decx1z
	dc.l	dcpx1z		;un-doc
	dc.l	cld
	dc.l	cmpy1
	dc.l	nop		;un-doc
	dc.l	dcpy1		;un-doc
	dc.l	nop		;un-doc 220
	dc.l	cmpx1
	dc.l	decx1
	dc.l	dcpx1		;un-doc
	dc.l	cpxh
	dc.l	sbcx
	dc.l	nop		;un-doc
	dc.l	isbx		;un-doc
	dc.l	cpxz
	dc.l	sbcz
	dc.l	incz		;230
	dc.l	isbz		;un-doc
	dc.l	inx
	dc.l	sbch
	dc.l	nop
	dc.l	sbch		;un-doc
	dc.l	cpx
	dc.l	sbc
	dc.l	inc
	dc.l	isb		;un-doc
	dc.l	beq		;240
	dc.l	sbcy
	dc.l	JAM		;un-doc
	dc.l	isby		;un-doc
	dc.l	nop		;un-doc
	dc.l	sbcx1z
	dc.l	incx1z
	dc.l	isbx1z		;un-doc
	dc.l	sed
	dc.l	sbcy1
	dc.l	nop		;un-doc 250
	dc.l	isby1		;un-doc
	dc.l	nop		;un-doc
	dc.l	sbcx1
	dc.l	incx1
	dc.l	isbx1		;un-doc 255

	include	ACTable.s

	cnop	0,4

COPPER_INT:
	dc.l	0,0
	dc.b	2,0			;type,priority 2=interrupt
	dc.l	CName2
	dc.l	CISData,CISInterrupt
CName2:	
	dc.b	"42-Interrupt",0
	even
CISData:
	dc.l	0

WriteVIC:
	dc.l	Sprite0X	;VIC Chip
	dc.l	Sprite0Y
	dc.l	Sprite1X
	dc.l	Sprite1Y
	dc.l	Sprite2X
	dc.l	Sprite2Y
	dc.l	Sprite3X
	dc.l	Sprite3Y
	dc.l	Sprite4X
	dc.l	Sprite4Y
	dc.l	Sprite5X
	dc.l	Sprite5Y
	dc.l	Sprite6X
	dc.l	Sprite6Y
	dc.l	Sprite7X
	dc.l	Sprite7Y
	dc.l	SpriteMSBX
	dc.l	VCRW1
	dc.l	RasterW
	dc.l	Nothing		;LightPen x
	dc.l	Nothing		;LightPen y
	dc.l	SpriteEN
	dc.l	VCRW2
	dc.l	SpriteYY
	dc.l	MCR
	dc.l	InterruptFRW
	dc.l	Nothing
	dc.l	Nothing		;Sprite Priority
	dc.l	SpriteMCM
	dc.l	SpriteXX
	dc.l	Nothing		;Sprite to Sprite Collision detect
	dc.l	Nothing		;Sprite to Background Collision detect
	dc.l	BorderCol
	dc.l	ScreenCol
	dc.l	ScreenCol1
	dc.l	ScreenCol2
	dc.l	ScreenCol3
	dc.l	SpriteMC0
	dc.l	SpriteMC1
	dc.l	Sprite0C
	dc.l	Sprite1C
	dc.l	Sprite2C
	dc.l	Sprite3C
	dc.l	Sprite4C
	dc.l	Sprite5C
	dc.l	Sprite6C
	dc.l	Sprite7C
WriteSID:
	dc.l	Nothing		;SID Chip
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Osci3
	dc.l	Nothing
WriteCIA1:
	dc.l	KeyWrite	;CIA 1
	dc.l	Nothing		;Will need later
	dc.l	Nothing		;DDR A
	dc.l	Nothing		;DDR B
	dc.l	Wc1TALO
	dc.l	Wc1TAHI
	dc.l	Wc1TBLO
	dc.l	Wc1TBHI
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Wc1ICR
	dc.l	Wc1CRA
	dc.l	Wc1CRB
WriteCIA2:
	dc.l	DPortAW		;CIA 2
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing
	dc.l	Nothing

Write1VIC:
	dc.l	WBSprite0X	;VIC Chip
	dc.l	WBSprite0Y
	dc.l	WBSprite1X
	dc.l	WBSprite1Y
	dc.l	WBSprite2X
	dc.l	WBSprite2Y
	dc.l	WBSprite3X
	dc.l	WBSprite3Y
	dc.l	WBSprite4X
	dc.l	WBSprite4Y
	dc.l	WBSprite5X
	dc.l	WBSprite5Y
	dc.l	WBSprite6X
	dc.l	WBSprite6Y
	dc.l	WBSprite7X
	dc.l	WBSprite7Y
	dc.l	WBSpriteMSBX
	dc.l	WBVCRW1
	dc.l	WBRasterW
	dc.l	WBNothing		;LightPen x
	dc.l	WBNothing		;LightPen y
	dc.l	WBSpriteEN
	dc.l	WBVCRW2
	dc.l	WBSpriteYY
	dc.l	WBMCR
	dc.l	WBInterruptFRW
	dc.l	WBNothing
	dc.l	WBNothing		;Sprite Priority
	dc.l	WBSpriteMCM
	dc.l	WBSpriteXX
	dc.l	WBNothing		;Sprite to Sprite Collision detect
	dc.l	WBNothing		;Sprite to Background Collision detect
	dc.l	WBBorderCol
	dc.l	WBScreenCol
	dc.l	WBScreenCol1
	dc.l	WBScreenCol2
	dc.l	WBScreenCol3
	dc.l	WBSpriteMC0
	dc.l	WBSpriteMC1
	dc.l	WBSprite0C
	dc.l	WBSprite1C
	dc.l	WBSprite2C
	dc.l	WBSprite3C
	dc.l	WBSprite4C
	dc.l	WBSprite5C
	dc.l	WBSprite6C
	dc.l	WBSprite7C
Write1SID:
	dc.l	WBNothing		;SID Chip
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBOsci3
	dc.l	WBNothing
Write1CIA1:
	dc.l	WBKeyWrite	;CIA 1
	dc.l	WBNothing		;Will need later
	dc.l	WBNothing		;DDR A
	dc.l	WBNothing		;DDR B
	dc.l	WBWc1TALO
	dc.l	WBWc1TAHI
	dc.l	WBWc1TBLO
	dc.l	WBWc1TBHI
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBWc1ICR
	dc.l	WBWc1CRA
	dc.l	WBWc1CRB
Write1CIA2:
	dc.l	WBDPortAW		;CIA 2
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing
	dc.l	WBNothing


ScrLUT:	dcb.l	1000,0

ColLUT:	dcb.l	1000,0

BMLUT:
	dcb.w	16000,0
TextTable:
	dcb.l	256*16,0
MultiTextTable:
	dcb.l	256*16,0
MCMColour:
	dcb.l	256*16,0
MCMBackground:
	dcb.b	256,0
MultiTextBack:
	dcb.b	256,0

SpritePC:
	dcb.b	256,0

ResetCPU:
	dc.w	0
BasicRAM:
	dc.l	0
KernalRAM:
	dc.l	0
CharRAM:
	dc.l	0
IORAM:
	dc.l	0
CharROMSwitch:
	dc.l	0
ShadowCopy:
	dc.l	0
Address:
	dc.l	0
WriteTable:
	dc.l	0
ReadTable:
	dc.l	0
BitPlaneTable:
	dc.l	0
MultiTable:
	dc.l	0
CROMAddy:
	dc.l	0
CharAddress:
	dc.l	0
ScreenAddress:
	dc.l	0
MCRCharLast:
	dc.w	0
MCRLast:
	dc.w	1024
VICBank:
	dc.w	0
OldVICBank:
	dc.w	0
IntFRTemp:
	dc.b	0
IntSR:
	dc.b	0
IDF:
	dc.b	-1
IRQ:
	dc.b	0
ECM:
	dc.b	0
MCM:
	dc.b	0
BMM:
	dc.b	0
BasicROM:
	dc.b	-1
KernalROM:
	dc.b	-1
CharROM:
	dc.b	-1
HiddenIO:
	dc.b	0
CountP:
	dc.b	5
Counter:
	dc.b	8
LRData:
	dc.b	0
EOITime:
	dc.b	0
SerCLK:
	dc.b	0
SerTalk:
	dc.b	0
SerData:
	dc.b	0
CIASkip:
	dc.b	0
CIACount2:
	dc.b	2
CIACount:
	dc.b	2
LoadByte:
	dc.b	0
IOFlag:
	dc.b	0
IOError:
	dc.b	0
DIR:
	dc.b	0
ReadST:
	dc.b	0
DriveST:
	dc.b	0
DriveMessage:
	dc.b	"73,CBM DOS V3.0 1570,00,00",13		;0,26
	dc.b	"00, OK,00,00",13			;27,12
	dc.b	"62,FILE NOT FOUND,00,00",13		;40,23
	dc.b	"31,SYNTAX ERROR,00,00",13		;64,21

	even
DriveMP:
	dc.l	0

CurrentLength:
	dc.l	0
FileLength:
	dc.l	0
Directory:
	dc.l	0
DirTemp:
	dc.l	0
Sprite0MSB:
	dc.w	0
Sprite1MSB:
	dc.w	0
Sprite2MSB:
	dc.w	0
Sprite3MSB:
	dc.w	0
Sprite4MSB:
	dc.w	0
Sprite5MSB:
	dc.w	0
Sprite6MSB:
	dc.w	0
Sprite7MSB:
	dc.w	0

Sprite0MC:
	dc.b	0
Sprite1MC:
	dc.b	0
Sprite2MC:
	dc.b	0
Sprite3MC:
	dc.b	0
Sprite4MC:
	dc.b	0
Sprite5MC:
	dc.b	0
Sprite6MC:
	dc.b	0
Sprite7MC:
	dc.b	0

Sprite0A:
	dc.b	0
Sprite1A:
	dc.b	0
Sprite2A:
	dc.b	0
Sprite3A:
	dc.b	0
Sprite4A:
	dc.b	0
Sprite5A:
	dc.b	0
Sprite6A:
	dc.b	0
Sprite7A:
	dc.b	0

Sprite0PT:
	dc.b	0
Sprite1PT:
	dc.b	0
Sprite2PT:
	dc.b	0
Sprite3PT:
	dc.b	0
Sprite4PT:
	dc.b	0
Sprite5PT:
	dc.b	0
Sprite6PT:
	dc.b	0
Sprite7PT:
	dc.b	0

Sprite0XX:
	dc.b	0
Sprite1XX:
	dc.b	0
Sprite2XX:
	dc.b	0
Sprite3XX:
	dc.b	0
Sprite4XX:
	dc.b	0
Sprite5XX:
	dc.b	0
Sprite6XX:
	dc.b	0
Sprite7XX:
	dc.b	0

Sprite0YY:
	dc.b	0
Sprite1YY:
	dc.b	0
Sprite2YY:
	dc.b	0
Sprite3YY:
	dc.b	0
Sprite4YY:
	dc.b	0
Sprite5YY:
	dc.b	0
Sprite6YY:
	dc.b	0
Sprite7YY:
	dc.b	0

Data:
	incbin	data.inc
Expand:
	incbin	expand.inc
Multi:
	incbin	multi.inc
Stretch:
	incbin	fourtimes.inc

MonoMode:
	dc.b	0,0,0,0
	dc.b	0,0,0,-1
	dc.b	0,0,-1,0
	dc.b	0,0,-1,-1
	dc.b	0,-1,0,0
	dc.b	0,-1,0,-1
	dc.b	0,-1,-1,0
	dc.b	0,-1,-1,-1
	dc.b	-1,0,0,0
	dc.b	-1,0,0,-1
	dc.b	-1,0,-1,0
	dc.b	-1,0,-1,-1
	dc.b	-1,-1,0,0
	dc.b	-1,-1,0,-1
	dc.b	-1,-1,-1,0
	dc.b	-1,-1,-1,-1

	Section	Copper,Data_C

	cnop	0,8

Sprite0:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite1:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite2:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite3:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite4:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite5:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite6:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite7:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
NullSprite:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0

MyCopList:
	dc.w	color00,$0000
	dc.w	color01,$0fff
Extra:
	dc.w	color03,$0000
	dc.w	color05,$0000
	dc.w	color09,$0000

	dc.w	bplcon4,$0010
	
	dc.w	color16,$0000	;black
	dc.w	color17,$0fff	;white
	dc.w	color18,$0d00	;red
	dc.w	color19,$00fd	;cyan
	dc.w	color20,$0f0f	;purple
	dc.w	color21,$00d0	;green
	dc.w	color22,$000d	;blue
	dc.w	color23,$0ff0	;yellow
	dc.w	color24,$0f80	;orange
	dc.w	color25,$0840	;brown
	dc.w	color26,$0f88	;lt red
	dc.w	color27,$0444	;grey1
	dc.w	color28,$0888	;grey2
	dc.w	color29,$08f8	;lt green
	dc.w	color30,$088f	;lt blue
	dc.w	color31,$0ccc	;grey3

	dc.w	diwstrt,$3481
	dc.w	bplcon0,$5200
	dc.w	bplcon2,$0224
	dc.w	bplcon3,$2c40
	dc.w	diwstop,$fcc1
	dc.w	ddfstrt,$0038
	dc.w	ddfstop,$00d0
	dc.w	bplcon1,$0000
	dc.w	bpl1mod,$fff8
	dc.w	bpl2mod,$fff8
	dc.w	bplcon4,$0032

SColour0:
	dc.w	color17,$0000		;odd
	dc.w	color21,$0000
	dc.w	color25,$0000
	dc.w	color29,$0000

MColour0:
	dc.w	color18,$0000
	dc.w	color19,$0000
	dc.w	color22,$0000
	dc.w	color23,$0000
	dc.w	color26,$0000
	dc.w	color27,$0000
	dc.w	color30,$0000
	dc.w	color31,$0000

SColour1:
	dc.w	color01,$0000		;odd
	dc.w	color05,$0000
	dc.w	color09,$0000
	dc.w	color13,$0000

MColour1:
	dc.w	color02,$0000
	dc.w	color03,$0000
	dc.w	color06,$0000
	dc.w	color07,$0000
	dc.w	color10,$0000
	dc.w	color11,$0000
	dc.w	color14,$0000
	dc.w	color15,$0000

	dc.w	bplcon3,$0c40
Screen:
	dc.w	bpl1pth,$0000
	dc.w	bpl1ptl,$0000

	dc.w	bpl2pth,$0000
	dc.w	bpl2ptl,$0000

	dc.w	bpl3pth,$0000
	dc.w	bpl3ptl,$0000

	dc.w	bpl4pth,$0000
	dc.w	bpl4ptl,$0000

	dc.w	bpl5pth,$0000
	dc.w	bpl5ptl,$0000

CSprite:
	dc.w	spr0pth,$0000,spr0ptl,$0000
	dc.w	spr1pth,$0000,spr1ptl,$0000
	dc.w	spr2pth,$0000,spr2ptl,$0000
	dc.w	spr3pth,$0000,spr3ptl,$0000

	dc.w	spr4pth,$0000,spr4ptl,$0000
	dc.w	spr5pth,$0000,spr5ptl,$0000
	dc.w	spr6pth,$0000,spr6ptl,$0000
	dc.w	spr7pth,$0000,spr7ptl,$0000

	dc.w	fmode,$000f
RastLP:
	mov	0,cop2lcl
	mov	0,cop2lch
RasterL:
	dc.w	$0001,$fffe	;y,x!1,$fffe
	dc.w	intreq,$8010

CopLEnd:
	wait	$ff,$fe			; End of Coplist
	cnop	0,4
